@extends("layouts.master")

@isset($dynamic)

@section("title") {{ $dynamic->title }} @endsection
@section("meta_keywords") {{ $dynamic->meta_keywords }} @endsection
@section("meta_description") {{ $dynamic->meta_description }} @endsection
@isset($dynamic->image)
@section("share_image")assets/dynamic/meta/{{ $dynamic->image }}@endsection
@endisset


@section("additional") {!! $dynamic->additional !!} @endsection

@endisset

@section('content')
        <!-- Banner  -->
        <section class="dz-bnr-inr style-1 breadcumb light" @isset($dynamic->banner) style="background-image: url({{ asset('assets/dynamic/banner/'.$dynamic->banner) }});" @endisset>
            
            <div class="container">
                <div class="dz-bnr-inr-entry">
                    <h1>OUR BLOG</h1>
                    <!-- Breadcrumb Row -->
                    <nav aria-label="breadcrumb" class="breadcrumb-row">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ url('') }}">Home</a></li>
                            <li class="breadcrumb-item">Our Blog</li>
                        </ul>
                    </nav>
                    <!-- Breadcrumb Row End -->
                </div>
            </div>
        </section>
        <!-- Banner End -->
        <div class="page-content bg-white">
            <!-- Blog Large -->
            <div class="content-inner">
                <div class="container">
                    <div class="row" id="masonry">
						
						@foreach ($blogs as $item)
                        <div class="col-xl-6 col-lg-6 card-container">
                            <div class="dz-card blog-grid style-1 m-b50 aos-item" data-aos="fade-up"
                                data-aos-duration="1000" data-aos-delay="200">
                                <div class="dz-media">
                                    <a href="{{ url('blog/'.$item->slug) }}"><img src="{{ asset('assets/dish/grid/'.$item->image) }}" alt=""></a>
                                </div>
								
                                <div class="dz-info">
									
                                    <div class="dz-meta">
                                        <ul>
                                            <li class="post-date">{{ $item->created_at->format('d/m/Y') }}</li>
                                        </ul>
                                    </div>
                           
									
                                    <h3 class="dz-title"><a href="{{ url('blog/'.$item->slug) }}">{{ $item->name }}</a></h3>
                                    <div class="dz-post-text text">
                                        <p>{{ $item->meta_description }}</p>
                                    </div>
                                    <a href="{{ url('blog/'.$item->slug) }}" class="btn shadow-primary icon-btn btn-primary"><i
                                            class="fas fa-caret-right"></i></a>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        
						
                    </div>
				
                </div>
            </div>


        </div>

@endsection     