@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    User View
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>User View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> User View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">User View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'user' }}">
                                    <i class="fa fa-list"></i> User List</a>
                            </div>


                            <div class="row">
                       

                                <div class="col-md-6">
                                    <div class="card-body">
                                      
                                        <div class="form-group">
                                            <label for="title">User Name</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $user->name }}">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control" disabled>
                                                <option value="1" @if ($user->status == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($user->status == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
@endsection
