@extends(config('app.admin.view').".layouts.master")

@section('title')
    User List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>User List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> User List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">User List</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'user/create' }}">
                                    <i class="fa fa-plus"></i> Add User</a>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>User Name</th>
                                            <th>Phone</th>
                                            <th>Role</th>
                                            <th>Status</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($users as $key=> $user)

                                        <tr>
                                            <td>{{ $key+1 }}.</td>
                                            <td>{{ $user['name'] }}</td>
                                            <td>{{ $user['phone'] }}</td>
                                            <td>{{ $user['role'] }}</td>
                                            <td>
                                                @if ($user['status'] == 1)
                                                    Active
                                                @else
                                                    Not Active
                                                @endif
                                            </td>
                                            <td>{{ $user['created_at']->format('d/m/Y') }}</td>
                                            <td>
                                                <a class="btn btn-info btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'user/show/'.encrypt($user->id)) }}"
                                                    title="Show"><i class="fa fa-eye"></i></a>
                                                <a class="btn btn-primary btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'user/edit/'.encrypt($user->id)) }}"
                                                    title="Edit"><i class="fa fa-edit"></i></a>
                                                
                                                @if ($user['role'] != 'superadmin')
                                                    <a class="btn btn-danger btn-sm my-1"
                                                        href="{{ (config('app.admin.url').'user/destroy/'.encrypt($user->id)) }}"
                                                        title="Delete"><i class="fa fa-trash"></i></a>
                                                @endif
                                            </td>
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
