@extends(config('app.admin.view').".layouts.master")

@section("title") Edit User @endsection

@section("content")

        <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
          
          <!-- Content Header (Page header) -->
          <section class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                <div class="col-sm-6">
                  <h4>Edit User</h4>
                </div>
                <div class="col-sm-6">
                  <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#"> Home </a></li>
                    <li class="breadcrumb-item active"> Edit User </li>
                  </ol>
                </div>
              </div>
            </div>
          </section>
          <!-- Content Header (Page header) -->
          
          <!-- Main content -->
          <section class="content">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-md-6 mb-4 mt-0">

                   

                        <div class="card card-primary">
                          <div class="card-header">
                                <h2 class="card-title">Edit User</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'user' }}">
                                    <i class="fa fa-list"></i> User List</a>
                            </div>

                            <form action="{{ (config('app.admin.url').'user/update/'.encrypt($user->id)) }}" method="POST" class="form-style3" enctype="multipart/form-data">
                            @csrf
                            @method('PATCH')
                            <div class="card-body">

                              <div class="form-group">
                                        <label for="exampleInputEmail1">User Name</label>
                                        <input type="text" name="name" class="form-control"
                                            placeholder="User Name" value="{{ $user->name }}">
                                    </div>


                             

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="1" @if ($user->status==1) selected @endif>Active</option>
                                                    <option value="0" @if ($user->status==0) selected @endif>Disabled</option>
                                                </select>
                                            </div>
                            </div>
                              <div class="card-footer text-right">
                              <button type="submit" class="btn btn-primary">Submit</button>
                              </div>
                            </form>
                            </div>    
                      </div>
                  </div>
              </div>
          </section>
    </div>

@endsection