@extends('admin.layouts.master')
@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Review List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Review List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                         <div class="card card-primary">
                            <div class="card-header ">
                                <h2 class="card-title">Review List</h2>
                                <a class="btn btn-dark text-white btn-sm float-right"
                                    href="{{ config('app.admin.url') . 'review/create' }}">
                                    <i class="fa fa-plus"></i> Add Review</a>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display datatable">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            <th>Image</th>
                                            <th>Review Content</th>
                                            <th>Status</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($reviews as $key => $review)

                                        <tr>
                                            <td>{{ $key+1 }}</td>
                                            <td>{{ $review->name }}</td>
                                            
                                            <td>
                                                 @if (!empty($review->image))
                                                <img  src="{{ asset($review->image) }}" style="width:100px;height:100px;">
                                                @else
                                                <img  src="{{ asset('assets/images/testimonials/1.png') }}" style="width:100px;height:100px;">
                                                @endif
                                            </td>

                                            <td>
                                                {{-- @if (!empty($review->review_image))
                                                    <img  src="{{ asset($review->review_image) }}" style="width:100px;height:100px;"> --}}
                                                {{-- @else --}}
                                                    <div style="max-width:500px;max-height:250px;overflow: auto;">{!! $review->review !!}</div>
                                                {{-- @endif --}}
                                                
                                            </td>

                                            <td>
                                                @if ($review->status == 1)
                                                    Active
                                                @else
                                                    Not Active
                                                @endif
                                            </td>
                                           
                                            <td>{{ date('d/m/Y',strtotime($review->created_at)) }}</td>
                                            <td>
                                                <a class=" btn-primary btn btn-sm"
                                                    href="{{ (config('app.admin.url').'review/edit/'.encrypt($review->id)) }}"
                                                    title="Edit"><i class="fa fa-edit"></i></a>
                                                <a class="btn-danger btn btn-sm"
                                                    href="{{ (config('app.admin.url').'review/destroy/'.encrypt($review->id)) }}"
                                                    title="Delete"><i class="fa fa-trash"></i></a>
                                            </td>
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
