@extends('admin.layouts.master')
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Edit Review</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Edit Review </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Edit Review</h2>
                                <a class="btn btn-dark text-white btn-sm float-right" href="{{ config('app.admin.url') . 'review' }}">
                                    <i class="fa fa-plus"></i> Review List</a>
                            </div>

                            <form action="{{ (config('app.admin.url').'review/update/' . encrypt($review->id)) }}" method="POST"
                                class="form-style3" enctype="multipart/form-data">
                                @csrf
                                @method('PATCH')
                                <div class="card-body">

                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Name</label>
                                        <input type="text" name="name" class="form-control" placeholder="Name"
                                            value="{{ $review->name }}">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Role</label>
                                        <input type="text" name="role" class="form-control" placeholder="Role"
                                            value="{{ $review->role }}">
                                    </div>

                                     <div class="form-group">
                                        <label for="exampleInputEmail1">Rating</label>
                                        <select type="text" name="rating" class="form-control">
                                            <option value="">-- Select Review --</option>
                                            <option value="5" @if ($review->rating == 5) selected @endif>5 star</option>
                                            <option value="4" @if ($review->rating == 4) selected @endif>4 star</option>
                                            <option value="3" @if ($review->rating == 3) selected @endif>3 star</option>
                                            <option value="2" @if ($review->rating == 2) selected @endif>2 star</option>
                                            <option value="1" @if ($review->rating == 1) selected @endif>1 star</option>
                                            <option value="0" @if ($review->rating == 0) selected @endif>0 star</option>
                                        </select>
                                    </div>


                                    <div class="form-group">
                                        <label for="image">Image</label>
                                        <input type="file" name="image" id="image" class="dropify" @if (!empty($review->image)) data-default-file="{{ asset($review->image) }}" @endif
                                            accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp"
                                           >
                                           

                                           @if (!empty($review->image))
                                               <a href="{{  asset($review->image) }}" target="new" class="btn btn-default form-control">Go to File</a>
                                           @endif
                                        
                                    </div>

                                    {{-- <div class="form-group">
                                        <label for="review_image">Review Image</label>
                                        <input type="file" name="review_image" id="review_image" class="form-control" data-max-file-size="2M">
                                        @if (!empty($review->review_image))
                                        <a href="{{  asset($review->review_image) }}" target="new" class="btn btn-default form-control">Go to File</a>
                                        @endif
                                    </div> --}}

                                    <div class="form-group">
                                        <label for="review">Review Content</label>
                                        <textarea  name="review" id="editor1"   placehoder="Enter Review" class="form-control">{{ $review->review }}</textarea>	
                                    </div>

                               
                                    
                                    <div class="form-group">


                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control">
                                                <option value="1" @if ($review->status == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($review->status == 0) selected @endif>
                                                    Disabled</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Home Show</label>
                                            <select name="home" class="form-control">
                                                <option value="1" @if ($review->home == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($review->home == 0) selected @endif>
                                                    Disabled</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="card-footer text-right">
                                        <button type="submit" class="btn btn-primary">Save</button>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
