@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Sports List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Sports List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Sports List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Sports List</h2>

                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Sports Name</th>
                                            <th>Team Name</th>
                                            <th>Captain Name</th>
                                            <th>Email</th>
                                            <th>Mobile Number</th>
                                            <th>Payment Entry Fee</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($sports as $key => $sports)
                                            <tr>
                                                <td>{{ $key + 1 }}.</td>
                                                <td>{{ $sports['sports_name'] }}</td>
                                                <td>{{ $sports['team_name'] }}</td>
                                                <td>{{ $sports['captain_name'] }}</td>
                                                <td>{{ $sports['email'] }}</td>
                                                <td>{{ $sports['phone'] }}</td>
                                                <td>{{ $sports['entry_fee'] }}</td>
                                                <td>{{ $sports['created_at']->format('d/m/Y') }}</td>
                                                <td>
                                                    <a class="btn btn-info btn-sm my-1"
                                                        href="{{ config('app.admin.url') . 'sports/show/' . encrypt($sports->id) }}"
                                                        title="Show"><i class="fa fa-eye"></i></a>

                                                    <a class="btn btn-danger btn-sm my-1"
                                                        href="{{ config('app.admin.url') . 'sports/destroy/' . encrypt($sports->id) }}"
                                                        title="Delete"><i class="fa fa-trash"></i></a>
                                                </td>

                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
