@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Scholarship View
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Scholarship View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Scholarship View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Scholarship View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'scholarship' }}">
                                    <i class="fa fa-list"></i> Scholarship List</a>
                            </div>


                            <div class="row">

                                @if (!empty($scholarship->reciept) || !empty($scholarship->image))
                                    <div class="col-md-6">
                                        <div class="card-body">
                                            <div class="form-group">
                                                <label for="reciept">Reciept Image</label>
                                                @isset($scholarship->reciept)
                                                    <img src="{{ asset('scholarship/reciept/' . $scholarship->reciept) }}"
                                                        class="img-fluid img-thumbnail" alt="{{ $scholarship->title }}" />
                                                    <a href="{{ asset('scholarship/reciept/' . $scholarship->reciept) }}"
                                                        target="new" class="btn btn-default form-control">Go to File</a>
                                                @endisset

                                            </div>

                                        </div>
                                    </div>


                                    <div class="col-md-6">
                                    @else
                                        <div class="col-md-12">
                                @endif
                                <div class="card-body">


                                    <div class="form-group">
                                        <label for="title"> Name</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->name }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title"> Father Name</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->father_name }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title"> Gender</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->gender }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title"> DOB</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->dob }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title"> Class</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->class }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title"> Phone</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->phone }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title"> Email</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->email }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title"> Religion</label>
                                        <input type="text" class="form-control" id="name" name="name" disabled
                                            value="{{ $scholarship->religion }}">
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> Adhar Number</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship->adhar_no }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> Caste</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship->caste }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> Pincode</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship->pincode }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> State</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship->state_name }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> District</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship->district_name }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> Address</label>
                                            <textarea type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship->address }}">{{ $scholarship->address }}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> Exam Center</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship->exam_center }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="title"> Date Time</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $scholarship['created_at']->format('d-m-Y h:i A') }}">
                                        </div>
                                    </div>
                                </div>



                            </div>
                        </div>

                    </div>
                </div>
            </div>
    </div>
    </section>
    </div>
@endsection
