@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Membership List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Membership List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Membership List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Membership List</h2>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            {{-- <th>User Id</th> --}}
                                            <th>Email</th>
                                            <th>Mobile Number</th>
                                            <th>DOB</th>
                                            <th>PAN Number</th>
                                            <th>Aadhar Number</th>
                                            <th>Joined On</th>
                                            <th>Status</th>
                                            <th>Address</th>
                                            {{-- <th>Action</th> --}}
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($memberships as $key => $member)
                                            <tr>
                                                <td>{{ $key + 1 }}.</td>
                                                <td>{{ $member['name'] }}</td>
                                                <td>{{ $member['email'] }}</td>
                                                <td>{{ $member['phone'] }}</td>
                                                <td>{{ $member['dob'] ?? '-' }}</td>
                                                <td>{{ $member['pan_number'] }}</td>
                                                <td>{{ $member['aadhaar_number'] }}</td>
                                                <td>{{ $member['created_at']->format('d/m/Y') }}</td>

                                                <td>
                                                    <span
                                                        class="badge 
                                                        {{ $member->status == 'active' ? 'badge-success' : ($member->status == 'rejected' ? 'badge-danger' : 'badge-warning') }}">
                                                        {{ ucfirst($member->status) }}
                                                    </span>
                                                </td>

                                                <td>{{ $member['address'] }}</td>
                                                {{-- <td>
                                                    <a class="btn btn-danger btn-sm my-1"
                                                        href="{{ config('app.admin.url') . 'membership/destroy/' . encrypt($member->id) }}"
                                                        title="Delete"><i class="fa fa-trash"></i></a>
                                                </td> --}}
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
