@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Project View
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Project View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Project View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Project View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'project' }}">
                                    <i class="fa fa-list"></i> Project List</a>
                            </div>


                            <div class="row">
                                
                                @if(!empty($project->banner) || !empty($project->image))
                                <div class="col-md-6">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="banner">Banner Image</label>
                                            @isset($project->banner)
                                                 <img src="{{ asset('assets/project/banner/' . $project->banner) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $project->title }}" />
                                                <a href="{{ asset('assets/project/banner/' . $project->banner) }}"
                                                    target="new" class="btn btn-default form-control">Go to File</a>
                                            @endisset
                                           
                                        </div>

                                        <div class="form-group">
                                            <label for="image">Image</label>
                                            @isset($project->image)
                                            <img src="{{ asset('assets/project/meta/' . $project->image) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $project->title }}" />
                                            <a href="{{ asset('assets/project/meta/' . $project->image) }}"
                                                target="new" class="btn btn-default form-control">Go to File</a>
                                                @endisset
                                        </div>

                                        {{-- <div class="form-group">
                                            <label for="catalogue">Catalogue</label>
                                            @isset($project->catalogue)
                                            
                                            <a href="{{ asset('assets/project/catalogue/' . $project->catalogue) }}"
                                                target="new" class="btn btn-default form-control">Go to File</a>
                                                @endisset
                                        </div> --}}
                                    </div>
                                </div>
                                

                                <div class="col-md-6">
                                    @else
                                    <div class="col-md-12">
                                    @endif
                                <div class="card-body">

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Home</label>
                                            <select name="home" class="form-control" disabled>
                                                <option value="1" @if ($project->home == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($project->home == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                      

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control" disabled>
                                                <option value="1" @if ($project->status == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($project->status == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="title">Project Name</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $project->name }}">
                                        </div>
                                        
                                        
                                        <div class="form-group">
                                            <label for="title">Title</label>
                                            <input type="text" class="form-control" id="title" name="title"
                                                disabled value="{{ $project->title }}">
                                        </div>                                
                                    
                                        <div class="form-group">
                                            <label for="title">Keywords</label>
                                            <input type="text" class="form-control" id="meta_keywords"
                                                name="meta_keywords" value="{{ $project->meta_keywords }}" disabled>
                                        </div>

                                        <div class="form-group">
                                            <label for="title">Description</label>
                                            <textarea class="form-control" rows="5" id="meta_description" disabled name="meta_description">{{ $project->meta_description }}</textarea>
                                        </div>
                                        

                                        <div class="form-group">
                                            <label for="title">Additional </label>
                                            <textarea class="form-control" rows="5" id="additional" disabled name="additional">{{ $project->additional }}</textarea>
                                        </div>
                                    </div>
                                </div>
                                @if ($project->page=="custom")
                                <div class="col-md-12">
                                    <div class="card-body">
                                        
                                        <div class="form-group">
                                            <label for="title">Page Details</label>
                                            <div class="p-2 border">{!! $project->details !!}</div>
                                        </div>
                                    </div>
                                    </div>
                              @endif

                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
@endsection
