@extends(config('app.admin.view').".layouts.master")

@section('title')
    Project List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Project List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Project List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Project List</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'project/create' }}">
                                    <i class="fa fa-plus"></i> Add Project</a>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Project</th>
                                            <th>Short Description</th>
                                            <th>Status</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($projects as $key=> $project)

                                        <tr>
                                            <td>{{ $key+1 }}.</td>
                                            <td>{{ $project['name'] }}</td>
                                            <td>{{ $project->shortDescription() }}</td>
                                            <td>
                                                @if ($project['status'] == 1)
                                                    Active
                                                @else
                                                    Not Active
                                                @endif
                                            </td>
                                            <td>{{ $project['created_at']->format('d/m/Y') }}</td>
                                            <td>
                                                <a class="btn btn-info btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'project/show/'.encrypt($project->id)) }}"
                                                    title="Show"><i class="fa fa-eye"></i></a>
                                                <a class="btn btn-primary btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'project/edit/'.encrypt($project->id)) }}"
                                                    title="Edit"><i class="fa fa-edit"></i></a>
                                                <a class="btn btn-danger btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'project/destroy/'.encrypt($project->id)) }}"
                                                    title="Delete"><i class="fa fa-trash"></i></a>
                                            </td>
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
