@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Industry View
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Industry View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Industry View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Industry View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'industry' }}">
                                    <i class="fa fa-list"></i> Industry List</a>
                            </div>


                            <div class="row">
                                
                                @if(!empty($industry->banner) || !empty($industry->image))
                                <div class="col-md-6">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="banner">Banner Image</label>
                                            @isset($industry->banner)
                                                 <img src="{{ asset('assets/industry/banner/' . $industry->banner) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $industry->title }}" />
                                                <a href="{{ asset('assets/industry/banner/' . $industry->banner) }}"
                                                    target="new" class="btn btn-default form-control">Go to File</a>
                                            @endisset
                                           
                                        </div>

                                        <div class="form-group">
                                            <label for="image">Image</label>
                                            @isset($industry->image)
                                            <img src="{{ asset('assets/industry/meta/' . $industry->image) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $industry->title }}" />
                                            <a href="{{ asset('assets/industry/meta/' . $industry->image) }}"
                                                target="new" class="btn btn-default form-control">Go to File</a>
                                                @endisset
                                        </div>
                                    </div>
                                </div>
                                

                                <div class="col-md-6">
                                    @else
                                    <div class="col-md-12">
                                    @endif
                                <div class="card-body">

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Menu Status</label>
                                            <select name="home" class="form-control" disabled>
                                                <option value="1" @if ($industry->home == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($industry->home == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control" disabled>
                                                <option value="1" @if ($industry->status == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($industry->status == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="title">Industry Name</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $industry->name }}">
                                        </div>
                                        
                                        
                                        <div class="form-group">
                                            <label for="title">Title</label>
                                            <input type="text" class="form-control" id="title" name="title"
                                                disabled value="{{ $industry->title }}">
                                        </div>                                
                                    
                                        <div class="form-group">
                                            <label for="title">Keywords</label>
                                            <input type="text" class="form-control" id="meta_keywords"
                                                name="meta_keywords" value="{{ $industry->meta_keywords }}" disabled>
                                        </div>

                                        <div class="form-group">
                                            <label for="title">Description</label>
                                            <textarea class="form-control" rows="5" id="meta_description" disabled name="meta_description">{{ $industry->meta_description }}</textarea>
                                        </div>
                                        

                                        <div class="form-group">
                                            <label for="title">Additional </label>
                                            <textarea class="form-control" rows="5" id="additional" disabled name="additional">{{ $industry->additional }}</textarea>
                                        </div>
                                    </div>
                                </div>
                                @if ($industry->page=="custom")
                                <div class="col-md-12">
                                    <div class="card-body">
                                        
                                        <div class="form-group">
                                            <label for="title">Page Details</label>
                                            <div class="p-2 border">{!! $industry->details !!}</div>
                                        </div>
                                    </div>
                                    </div>
                              @endif

                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
@endsection
