@extends(config('app.admin.view') . '.layouts.master')

@section('title', 'Dashboard')

@section('content')
<div class="content-wrapper">

    <!-- Hero Section -->
    <section class="content-header text-center py-5 bg-gradient-primary text-white shadow-lg animate__animated animate__fadeInDown">
        <div class="container">
            <h1 class="display-4 animate__animated animate__bounceIn">🌟 Welcome to Volunteer Dashboard 🌟</h1>
            <p class="lead animate__animated animate__fadeInUp animate__delay-1s">
                Generate, Manage & Explore Opportunities in One Place
            </p>
        </div>
    </section>

    <!-- Cards Section -->
    <section class="content mt-5">
        <div class="container-fluid">
            <div class="row">

                <!-- ID Card -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card shadow-lg rounded-lg border-0 hover-card animate__animated animate__zoomIn">
                        <div class="card-body text-center">
                            <i class="fas fa-id-card fa-3x text-primary mb-3"></i>
                            <h5 class="card-title">Generate ID Card</h5>
                            <p class="card-text">Create your official volunteer ID card with QR verification.</p>
                        </div>
                    </div>
                </div>

                <!-- Certificate -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card shadow-lg rounded-lg border-0 hover-card animate__animated animate__zoomIn animate__delay-1s">
                        <div class="card-body text-center">
                            <i class="fas fa-certificate fa-3x text-success mb-3"></i>
                            <h5 class="card-title">Get Certificate</h5>
                            <p class="card-text">Download your achievement and participation certificates.</p>
                        </div>
                    </div>
                </div>

                <!-- Appointment Letter -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card shadow-lg rounded-lg border-0 hover-card animate__animated animate__zoomIn animate__delay-2s">
                        <div class="card-body text-center">
                            <i class="fas fa-file-contract fa-3x text-warning mb-3"></i>
                            <h5 class="card-title">Appointment Letter</h5>
                            <p class="card-text">Access and print your official appointment letters anytime.</p>
                        </div>
                    </div>
                </div>

                <!-- Donation -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card shadow-lg rounded-lg border-0 hover-card animate__animated animate__zoomIn animate__delay-3s">
                        <div class="card-body text-center">
                            <i class="fas fa-hand-holding-heart fa-3x text-danger mb-3"></i>
                            <h5 class="card-title">Make a Donation</h5>
                            <p class="card-text">Support our cause by making a meaningful contribution.</p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- Quote / Footer Section -->
    <section class="content-footer text-center py-5 bg-light shadow-inner animate__animated animate__fadeInUp animate__delay-2s">
        <div class="container">
            <blockquote class="blockquote">
                <p class="mb-0">"Together we can make a difference, one step at a time."</p>
                <footer class="blockquote-footer">Volunteer Community</footer>
            </blockquote>
        </div>
    </section>

</div>
@endsection

@push('styles')
<!-- Animate.css -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

<style>
    .bg-gradient-primary {
        background: linear-gradient(135deg, #4f46e5, #3b82f6, #06b6d4);
    }
    .hover-card {
        transition: transform 0.4s ease, box-shadow 0.4s ease;
        border-radius: 20px;
    }
    .hover-card:hover {
        transform: translateY(-12px) scale(1.05);
        box-shadow: 0 15px 30px rgba(0,0,0,0.2);
    }
    .shadow-inner {
        box-shadow: inset 0px 5px 20px rgba(0,0,0,0.1);
    }
</style>
@endpush

@push('scripts')
<script>
    // Loop animation effect for cards
    document.querySelectorAll('.hover-card').forEach((card, index) => {
        setInterval(() => {
            card.classList.add('animate__pulse');
            setTimeout(() => card.classList.remove('animate__pulse'), 1000);
        }, 5000 + (index * 1000)); // staggered pulse effect
    });
</script>
@endpush
