@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Dynamic Page View
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Dynamic Page View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Dynamic Page View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Dynamic Page View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'dynamic' }}">
                                    <i class="fa fa-list"></i> Dynamic Page List</a>
                            </div>


                            <div class="row">
                                
                                @if(!empty($dynamic->banner) || !empty($dynamic->image))
                                <div class="col-md-6">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="banner">Banner Image</label>
                                            @isset($dynamic->banner)
                                                 <img src="{{ asset('assets/dynamic/banner/' . $dynamic->banner) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $dynamic->title }}" />
                                                <a href="{{ asset('assets/dynamic/banner/' . $dynamic->banner) }}"
                                                    target="new" class="btn btn-default form-control">Go to File</a>
                                            @endisset
                                           
                                        </div>

                                        <div class="form-group">
                                            <label for="image">Image</label>
                                            @isset($dynamic->image)
                                            <img src="{{ asset('assets/dynamic/meta/' . $dynamic->image) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $dynamic->title }}" />
                                            <a href="{{ asset('assets/dynamic/meta/' . $dynamic->image) }}"
                                                target="new" class="btn btn-default form-control">Go to File</a>
                                                @endisset
                                        </div>
                                    </div>
                                </div>
                                

                                <div class="col-md-6">
                                    @else
                                    <div class="col-md-12">
                                    @endif
                                <div class="card-body">

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control" disabled>
                                                <option value="1" @if ($dynamic->status == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($dynamic->status == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="title">Dynamic Page Name</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="{{ $dynamic->name }}">
                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="title">Slug</label>
                                            <input type="text" class="form-control" id="slug" name="slug"
                                                disabled value="{{ $dynamic->slug }}">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="title">Title</label>
                                            <input type="text" class="form-control" id="title" name="title"
                                                disabled value="{{ $dynamic->title }}">
                                        </div>                                
                                    
                                        <div class="form-group">
                                            <label for="title">Keywords</label>
                                            <input type="text" class="form-control" id="meta_keywords"
                                                name="meta_keywords" value="{{ $dynamic->meta_keywords }}" disabled>
                                        </div>

                                        <div class="form-group">
                                            <label for="title">Description</label>
                                            <textarea class="form-control" rows="5" id="meta_description" disabled name="meta_description">{{ $dynamic->meta_description }}</textarea>
                                        </div>
                                        

                                        <div class="form-group">
                                            <label for="title">Additional </label>
                                            <textarea class="form-control" rows="5" id="additional" disabled name="additional">{{ $dynamic->additional }}</textarea>
                                        </div>
                                    </div>
                                </div>
                                @if ($dynamic->page=="custom")
                                <div class="col-md-12">
                                    <div class="card-body">
                                        
                                        <div class="form-group">
                                            <label for="title">Page Details</label>
                                            <div class="p-2 border">{!! $dynamic->details !!}</div>
                                        </div>
                                    </div>
                                    </div>
                              @endif

                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
@endsection
