@extends(config('app.admin.view').".layouts.master")

@section('title')
    Contact Enquiry List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Contact Enquiry List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Contact Enquiry List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Contact Enquiry List</h2>
                                
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Mobile Number</th>
                                            <th>Message</th>
                                            <th>Status</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($contacts as $key=> $contact)

                                        <tr>
                                            <td>{{ $key+1 }}.</td>
                                            <td>{{ $contact['name'] }}</td>
                                            <td>{{ $contact['email'] }}</td>
                                            <td>{{ $contact['mobile'] }}</td>
                                            <td>{{ $contact['message'] }}</td>
                                            <td>
                                                @if ($contact['status'] == 1)
                                                    Active
                                                @else
                                                    Not Active
                                                @endif
                                            </td>
											<td>{{ $contact['created_at']->format('d/m/Y') }}</td>
                                            <td>
<a class="btn btn-danger btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'contact/destroy/'.encrypt($contact->id)) }}"
                                                    title="Delete"><i class="fa fa-trash"></i></a>
</td>
                                         
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
