@extends(config('app.admin.view') . '.layouts.master')

@section('title', 'Generate Certificate')

@section('content')
    <div class="content-wrapper">
        <!-- Page Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Certificate</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ url('/admin/dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Generate Certificate</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card p-4">

                            {{-- Directly display certificate for logged-in volunteer --}}
                            @if ($volunteer)
                                <div class="certificate mx-auto" id="certificate">
                                    <div class="certificate-inner">

                                        <div class="establish">Est. 2022</div> <!-- 👈 new line -->

                                        <img src="{{ asset('logo-1726730459.webp') }}" alt="Logo"
                                            class="certificate-logo">

                                        <h2 class="cert-title">Certificate of Membership</h2>
                                        <p class="cert-subtitle">This certifies that</p>

                                        <div class="cert-name">{{ strtoupper($volunteer->name) }}</div>

                                        <p class="cert-text">
                                            has been officially granted membership of <br>
                                            <strong>GMM Educational Trust and Welfare Association</strong>.
                                        </p>

                                        <div class="cert-footer">
                                            <div class="footer-left">
                                                <span>
                                                    {{ $volunteer->issue_date ?? ($volunteer->created_at ? $volunteer->created_at->format('d-m-Y') : now()->format('d-m-Y')) }}
                                                </span>
                                                <div class="footer-line"></div>
                                                <span>Date</span>
                                            </div>
                                            <div class="footer-right">
                                                <img src="{{ asset($settings->signature) }}" alt="Signature"
                                                    class="signature-img">
                                                <div class="footer-line"></div>
                                                <span>Authorized Signature</span>
                                            </div>
                                        </div>

                                        <div class="qr-block">
                                            <img crossOrigin="anonymous"
                                                src="https://api.qrserver.com/v1/create-qr-code/?size=90x90&data={{ url('certificate/verify?id=' . $volunteer->id) }}"
                                                alt="QR Code">
                                            <div class="cert-id">ID: GMM-{{ $volunteer->id }}</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="text-center mt-4">
                                    <button id="download-certificate-png" class="btn btn-success me-2">Download
                                        Certificate</button>
                                    <button id="print-certificate" class="btn btn-warning">Print Certificate</button>
                                </div>
                            @elseif(request('id'))
                                <div class="alert alert-danger mt-4">Volunteer not found.</div>
                            @endif

                        </div>
                    </div>
                </div>

            </div>
        </section>
    </div>

    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Georgia', serif;
        }

        .certificate {
            max-width: 900px;
            height: 650px;
            background: #fcf9f2;
            border: 15px solid #d4af37;
            padding: 40px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            position: relative;
        }

        .certificate-inner {
            border: 3px solid #1e3a8a;
            height: 100%;
            padding: 50px 60px;
            text-align: center;
            position: relative;
        }

        .establish {
            position: absolute;
            top: 30px;
            left: 30px;
            font-size: 14px;
            font-weight: bold;
            color: #555;
            font-family: 'Georgia', serif;
        }

        .certificate-logo {
            width: 90px;
            margin: -20px auto 10px;
            background-color: #000;
            border-radius: 50%;
        }

        .cert-title {
            font-size: 42px;
            font-weight: bold;
            text-transform: uppercase;
            color: #1e3a8a;
            margin-bottom: 10px;
            letter-spacing: 3px;
        }

        .cert-subtitle {
            font-size: 20px;
            font-style: italic;
            margin-bottom: 25px;
            color: #444;
        }

        .cert-name {
            font-size: 36px;
            font-weight: bold;
            margin: 20px 0;
            color: #b8860b;
            text-transform: uppercase;
            letter-spacing: 2px;
            text-shadow: 1px 1px 3px rgba(184, 134, 11, 0.3);
        }

        .cert-text {
            font-size: 18px;
            color: #333;
            margin-bottom: 50px;
            line-height: 1.6;
        }

        .cert-footer {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            /* dono ko neeche ek line pe align karega */
            margin-top: 40px;
            font-size: 16px;
            color: #222;
            font-family: 'Georgia', serif;
            text-align: center;
        }

        .footer-left,
        .footer-right {
            /* width: 200px; */
            text-align: center;
            position: relative;
        }

        .footer-line {
            width: 160px;
            height: 1px;
            background: #000;
            margin: 5px auto;
        }

        .signature-img {
            width: 120px;
            height: auto;
            position: absolute;
            bottom: 25px;
            /* line ke just upar aa jayega */
            left: 50%;
            transform: translateX(-50%);
        }


        .qr-block {
            position: absolute;
            top: 30px;
            right: 30px;
            text-align: center;
        }

        .qr-block img {
            background: #fff;
            padding: 6px;
            border: 1px solid #ccc;
            width: 90px;
        }

        .qr-block .cert-id {
            margin-top: 6px;
            font-size: 13px;
            font-weight: bold;
        }
    </style>

    {{-- Scripts --}}
    <script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
    <script>
        document.getElementById('download-certificate-png')?.addEventListener('click', function() {
            var cert = document.getElementById('certificate');
            html2canvas(cert, {
                scale: 2,
                useCORS: true,
                backgroundColor: null
            }).then(function(canvas) {
                var link = document.createElement('a');
                link.download = 'certificate.png';
                link.href = canvas.toDataURL();
                link.click();
            });
        });
        document.getElementById('print-certificate')?.addEventListener('click', function() {
            var cert = document.getElementById('certificate');
            html2canvas(cert, {
                scale: 2,
                useCORS: true,
                backgroundColor: null
            }).then(function(canvas) {
                const imgData = canvas.toDataURL('image/png');
                const win = window.open('');
                win.document.write(
                    '<html><head><title>Print Certificate</title></head><body style="margin:0;">');
                win.document.write('<img src="' + imgData +
                    '" onload="setTimeout(() => window.print(), 100)" style="width:100%;">');
                win.document.write('</body></html>');
                win.document.close();
            });
        });
    </script>
@endsection
