@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Banner View
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Banner View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Banner View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Banner View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'banner' }}">
                                    <i class="fa fa-list"></i> Banner List</a>
                            </div>


                            <div class="row">
                                
                               
                                <div class="col-md-6">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="image">Image</label>
                                            <img src="{{ asset('assets/banner/' . $banner->image) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $banner->title }}" />
                                            <a href="{{ asset('assets/banner/' . $banner->image) }}"
                                                target="new" class="btn btn-default form-control">Go to File</a>
                                        </div>

                                        <div class="form-group">
                                            <label for="title">Banner Title</label>
                                            <input type="text" class="form-control" id="title" name="title"
                                                disabled value="{{ $banner->title }}">
                                        </div>
                                      
{{-- 
                                         <div class="form-group">
                                            <label for="pretitle">Pre Title</label>
                                            <input type="text" class="form-control" id="pretitle" name="pretitle"
                                                disabled value="{{ $banner->pretitle }}">
                                        </div> --}}


                                    </div>

                                    
                                </div>

                                <div class="col-md-6">
                                    <div class="card-body">
                                      
                                        <div class="form-group">
                                            <label for="description">Banner Description</label>
                                            <textarea type="text" class="form-control" id="description" name="description"
                                                disabled >{!! $banner->description !!}</textarea>
                                        </div>
                                        
                                      
                                        
                                        <div class="form-group">
                                            <label for="link">Link</label>
                                            <input type="text" class="form-control" id="link" name="link"
                                                disabled value="{{ $banner->link }}">
                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="linktext">Link text</label>
                                            <input type="text" class="form-control" id="linktext" name="linktext"
                                                disabled value="{{ $banner->linktext }}">
                                        </div>
                                        
                                        
                                      
                                        <div class="form-group">
                                            <label for="link2">Link 2</label>
                                            <input type="text" class="form-control" id="link2" name="link2"
                                                disabled value="{{ $banner->link2 }}">
                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="linktext2">Link text 2</label>
                                            <input type="text" class="form-control" id="linktext2" name="linktext2"
                                                disabled value="{{ $banner->linktext2 }}">
                                        </div>
                                        

                                        
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control" disabled>
                                                <option value="1" @if ($banner->status == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($banner->status == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>

                                       
                                    </div>
                                    </div>
                              

                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
@endsection
