@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Edit Banner
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Edit Banner</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Edit Banner </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Edit Banner</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'banner' }}">
                                    <i class="fa fa-list"></i> Banner List</a>
                            </div>

                            <form action="{{ config('app.admin.url') . 'banner/update/' . encrypt($banner->id) }}"
                                method="POST" class="form-style3" enctype="multipart/form-data">
                                @csrf
                                @method('PATCH')
                                <div class="card-body">


                                    <div class="row">
                                        <div class="col-md-6">

                                            <div class="form-group">
                                                <label for="image"> Image</label>
                                                <input type="file" name="image" id="image" class="dropify mb-2"
                                                    accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp"
                                                    data-default-file="{{ asset('assets/banner/' . $banner->image) }}"
                                                    data-max-file-size="2M">
                                                <a href="{{ asset('assets/banner/' . $banner->image) }}" target="new"
                                                    class="btn btn-default form-control">Go to File</a>
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Banner Title</label>
                                                <input type="text" name="title" class="form-control"
                                                    placeholder="Banner Title" value="{{ $banner->title }}">
                                            </div>

                                            {{-- <div class="form-group">
                                                <label for="exampleInputEmail1">Pre Title</label>
                                                <input type="text" name="pretitle" class="form-control"
                                                    placeholder="Pre Title" value="{{ $banner->pretitle }}">
                                            </div> --}}


                                        </div>
                                        <div class="col-md-6">


                                            

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Link</label>
                                                <input type="text" name="link" class="form-control"
                                                    placeholder="Link" value="{{ $banner->link }}">
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Link text</label>
                                                <input type="text" name="linktext" class="form-control"
                                                    placeholder="Link text" value="{{ $banner->linktext }}">
                                            </div>
                                            
                                            
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Link 2</label>
                                                <input type="text" name="link2" class="form-control"
                                                    placeholder="Link" value="{{ $banner->link2 }}">
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Link text 2</label>
                                                <input type="text" name="linktext2" class="form-control"
                                                    placeholder="Link" value="{{ $banner->linktext2 }}">
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="1"
                                                        @if ($banner->status == 1) selected @endif>Active</option>
                                                    <option value="0"
                                                        @if ($banner->status == 0) selected @endif>Disabled</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Banner Description</label>
                                                <textarea type="text" name="description" id="description" class="form-control"
                                                    placeholder="Banner Description">{{ $banner->description }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    {{-- <script>
        $(document).ready(function () {
            $('#description').summernote({
              'height':'200px'
            });
        });
    </script> --}}
@endsection
