@extends(config('app.admin.view') . '.layouts.master')

@section('title', 'Appointment Letter')

@section('content')
    <div class="content-wrapper">

        <!-- Page Header -->
        <section class="content-header">
            <h4>Appointment Letter</h4>
        </section>

        <!-- Page Content -->
        <section class="content">
            <div class="container-fluid">
                <div id="appointmentLetter" class="p-5"
                    style="background: #fff; border: 2px solid #000; font-size: 16px; line-height: 1.8; max-width: 800px; margin: auto;">

                    <div class="text-center mb-4">
                        <h2 style="margin: 0; font-weight: bold;">GMM Educational Trust And Welfare Association</h2>
                        <p style="margin: 0;">Official Appointment Letter</p>
                        <hr style="border-top: 2px solid #000;">
                    </div>

                    <p style="text-align: right;">Date: {{ now()->format('d-m-Y') }}</p>

                    <p>To,</p>
                    <p><strong>{{ $user->name ?? 'Volunteer Name' }}</strong><br>
                        {{ $user->email ?? 'Volunteer Email' }}</p>

                    <p><strong>Subject:</strong> Appointment as Volunteer at GMM Educational Trust And Welfare Association
                    </p>

                    <p>Dear {{ $user->name ?? 'Volunteer' }},</p>

                    <p>
                        We are pleased to appoint you as a <strong>Volunteer</strong> of our organization,
                        GMM Educational Trust And Welfare Association.
                        Your dedication and contribution will play an important role in achieving the mission and vision of
                        our association.
                    </p>

                    <p>
                        We look forward to your continued support and active participation in all activities of
                        GMM Educational Trust And Welfare Association.
                    </p>

                    <br><br>
                    <p>With Regards,</p>
                    <p><strong>GMM Educational Trust And Welfare Association</strong></p>

                    <div style="margin-top: 80px;">
                        <p>__________________________<br>
                            Authorized Signatory</p>
                    </div>
                </div>

                <div class="text-center mt-4 pb-4">
                    <button id="downloadBtn" class="btn btn-primary">
                        <i class="fas fa-download"></i> Download
                    </button>
                </div>
            </div>
        </section>
    </div>

    <!-- ✅ Only jsPDF CDN (no html2canvas needed) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

    <script>
        document.getElementById("downloadBtn").addEventListener("click", function() {
            const {
                jsPDF
            } = window.jspdf;
            const pdf = new jsPDF("p", "mm", "a4");

            pdf.html(document.querySelector("#appointmentLetter"), {
                callback: function(doc) {
                    doc.save("appointment_letter.pdf");
                },
                margin: [15, 15, 15, 15], // padding for A4
                autoPaging: 'text',
                x: 0,
                y: 0,
                width: 180, // fit content in A4 width
                windowWidth: 800
            });
        });
    </script>
@endsection
