@extends('layouts.master')

@isset($dynamic)

    @section('title')
        {{ $dynamic->title }}
    @endsection
    @section('meta_keywords')
        {{ $dynamic->meta_keywords }}
    @endsection
    @section('meta_description')
        {{ $dynamic->meta_description }}
    @endsection

    @isset($dynamic->image)
        @section('share_image')
            assets/dynamic/meta/{{ $dynamic->image }}
        @endsection
    @endisset


    @section('additional')
        {!! $dynamic->additional !!}
    @endsection

@endisset

@section('content')
    <style>
        .doc {
            border-radius: 20px;
            box-shadow: 0 0 20px 0px #8b8b8b;
            border: 12px solid #cedbe7;
        }
    </style>
    <main>

        <div class="slider-area"
            @isset($dynamic->banner) style="background-image: url({{ asset('assets/dynamic/banner/' . $dynamic->banner) }});" @endisset>
            <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-xl-5 col-lg-6 col-md-6">
                            <div class="hero-caption hero-caption2">
                                <h2>About Us</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="support-company-area section-padding">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-xl-6 col-lg-6 col-md-10">
                        <div class="support-location-img">
                            <div class="row">
                                <div class="col-md-5 d-none d-lg-block">
                                    <div class="mb-3"><img src="{{ asset('assets/img/about-education-1.jpg') }}"
                                            alt="" /></div>
                                    <br>
                                    <div><img src="{{ asset('assets/img/gallery/about.jpg') }}" alt="" /></div>
                                </div>
                                <div class="col-md-7"><img src="{{ asset('assets/img/about-education.jpg') }}"
                                        alt="" /></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 col-md-10">
                        <div class="right-caption">


                            <div class="section-tittle">
                                <span class="text-theme2">About Us</span>
                                <h2>Welcome To <span class="text-theme">GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION</span>
                                </h2>
                            </div>
                            <div class="support-caption">
                                <p class="mb-10">
                                    At GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION, we strive to make a positive impact on
                                    society. Our mission is to uplift lives and
                                    create a better future for all. With a focus on education, health, agriculture, sports,
                                    and
                                    scholarships, we work tirelessly to support causes that matter the most.
                                </p>
                                <p class="pera-top">
                                    A charitable organization, our work transcends borders, touching the lives of
                                    individuals and
                                    communities in need. We believe in inclusivity and compassion, and our efforts are
                                    driven by a desire
                                    to bring positive change to as many lives as possible.
                                </p>
                                <a href="{{ url('projects') }}" class="btn about-btn">Projects</a>
                                <a class="optional-btn" href="{{ url('contact') }}">
                                    Contact Us
                                    <i class="ti-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="join-us-area section-padding  bg-1">
            <div class="container">
                <div class="row align-items-center">

                    <div class="col-md-12 mb-3 text-center">
                        <span>Our Company</span>
                        <h3>Company Documents</h3>

                    </div>
                    <div class="col-md-6">
                        <div class="joning-img doc">
                            <img src="{{ asset('assets/pan.png') }}" alt="" class="w-100 img-thumbnail">
                            <h5 class="text-center">GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION PAN</h5>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="joning-img doc mb-4">
                            <a href="{{ asset('assets/20-29.pdf') }}" target="_blank" alt=""
                                class="btn btn-dark w-100 img-thumbnail"> 20-29 form | Download / Open </a>

                        </div>
                        <div class="joning-img doc mb-4">
                            <a href="{{ asset('assets/1-19.pdf') }}" target="_blank" alt=""
                                class="btn btn-dark w-100 img-thumbnail"> 01-19 form | Download / Open </a>

                        </div>

                        <div class="joning-img doc mb-4">
                            <a href="{{ asset('assets/e-anudan.pdf') }}" target="_blank" alt=""
                                class="btn btn-dark w-100 img-thumbnail"> G-Anudan | Download / Open </a>

                        </div>

                        <div class="joning-img doc mb-4">
                            <a href="{{ asset('assets/GM.pdf') }}" target="_blank" alt=""
                                class="btn btn-dark w-100 img-thumbnail"> NGO ID | Download / Open </a>

                        </div>
                    </div>
                </div>
            </div>
        </div>



        <section class="solve-section  pt-60 pb-30">
            <div class="container">
                <div class="row align-items-center">

                    <div class="col-lg-6">
                        <div class="solve-area-content">
                            <span>Our Mission</span>
                            <h3>Empowering Dreams through Opportunities</h3>
                            <p>At GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION, we believe that where ambition meets
                                opportunity, anything becomes possible. Our
                                dedication is to create a world where every individual's potential is nurtured and realized,
                                regardless
                                of their circumstances.</p>
                            <p>We strive to make a positive impact on society by providing support and resources to various
                                projects
                                in education, health, agriculture, sports, and scholarships. Lorem ipsum dolor sit amet
                                consectetur
                                adipisicing elit. Maiores facere error et, minima repudiandae dignissimos! Lorem ipsum dolor
                                sit amet
                                consectetur adipisicing elit. Ullam voluptatum quam dignissimos. Hic quod iure tempora!
                                Maiores odio
                                dolorem nemo? Magnam inventore molestiae hic aliquam numquam, ea ipsa magni rerum?</p>
                            <div class="solve-btn">
                                <a href="{{ url('donate') }}" class="default-btn">
                                    Donate Now
                                    <i class="ti-arrow-right"></i>
                                    <span style="top: 69.6125px; left: 94.4px;"></span>
                                </a>
                                <a class="optional-btn" href="{{ url('announcements') }}">
                                    Announcements
                                    <i class="ti-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="row">
                            <div class="col-lg-6 col-md-6">
                                <div class="solve-item">
                                    <div class="icon">
                                        <img src="{{ asset('assets/img/solve/1.png') }}" alt="image">
                                    </div>
                                    <h3>Education</h3>
                                    <p>Our mission is to provide access to quality education for all, empowering minds to
                                        reach their full
                                        potential.</p>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="solve-item">
                                    <div class="icon">
                                        <img src="{{ asset('assets/img/solve/2.png') }}" alt="image">
                                    </div>
                                    <h3>Health</h3>
                                    <p>We aim to improve healthcare facilities, ensuring better medical care and well-being
                                        for the
                                        community.</p>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="solve-item">
                                    <div class="icon">
                                        <img src="{{ asset('assets/img/solve/3.png') }}" alt="image">
                                    </div>
                                    <h3>Sports</h3>
                                    <p>Promoting sports and physical activities for a healthier and more active lifestyle.
                                    </p>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="solve-item">
                                    <div class="icon">
                                        <img src="{{ asset('assets/img/solve/4.png') }}" alt="image">
                                    </div>
                                    <h3>Agriculture</h3>
                                    <p>Supporting sustainable agriculture practices for food security and economic growth.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </section>

        <div class="join-us-area bg-1 section-padding">
            <div class="container">
                <div class="row align-items-center">

                    <div class="col-xl-4 col-lg-4 col-md-7 col-sm-7">
                        <div class="joning-img">
                            <img src="{{ asset('assets/img/gallery/joining1.jpg') }}" alt="" class="w-100">
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-5 col-sm-5">
                        <div class="joning-img">
                            <img src="{{ asset('assets/img/gallery/joining2.jpg') }}" alt="" class="w-100">
                        </div>
                    </div>
                    <div class=" offset-xl-1 col-xl-4 col-lg-6 col-md-10">
                        <div class="joing-details">
                            <div class="section-tittle">
                                <h2>Join with Us</h2>
                            </div>
                            <p>The legal definition of a charitable organization (and of charity) varies between countries
                                and in some
                                instances regions of the country. The regulation, the tax treatment, and the way.</p>
                            <a href="{{ url('volunteer') }}" class="btn about-btn">
                                Become A Volunteer
                                <i class="flaticon-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </main>
@endsection
