self.addEventListener("install", (event) => {
    console.log("Service worker installed");
    event.waitUntil(
        caches
            .open("my-cache")
            .then((cache) => {
                return cache.addAll([
                    "/",
                    "/public/logo.png",
                    "/pwa-sw.js",
                    "/no-internet.html",
                ]);
            })
            .then(() => self.skipWaiting())
    );
});

self.addEventListener("fetch", (event) => {
    if (event.request.url.startsWith("chrome-extension://")) {
        // If the request URL starts with "chrome-extension://", do not try to cache it
        return;
    }
    if (event.request.method !== "GET") {
        // If the request method is not GET, do not try to cache it
        return;
    }

    event.respondWith(
        caches.match(event.request).then((response) => {
            if (response) {
                // If the cache has a match for the request, check if the resource has been updated
                return fetch(event.request)
                    .then((networkResponse) => {
                        if (networkResponse.ok) {
                            // If the network response is ok, update the cache with the new response
                            const clonedResponse = networkResponse.clone();
                            caches.open("my-cache").then((cache) => {
                                cache.put(event.request, clonedResponse);
                            });
                        }
                        return response;
                    })
                    .catch(() => response);
            }
            // If the cache doesn't have a match for the request,
            // try fetching it from the network and cache the response
            return fetch(event.request)
                .then((networkResponse) => {
                    if (networkResponse.ok) {
                        const clonedResponse = networkResponse.clone();
                        caches.open("my-cache").then((cache) => {
                            cache.put(event.request, clonedResponse);
                        });
                    }
                    return networkResponse;
                })
                .catch(() => {
                    // If fetching from the network fails, return the fallback page
                    return caches.match("/no-internet.html");
                });
        })
    );
});


self.addEventListener("activate", (event) => {
    console.log("Service worker activated");
    event.waitUntil(
        caches
            .keys()
            .then((cacheNames) => {
                return Promise.all(
                    cacheNames.map((cacheName) => {
                        if (cacheName !== "my-cache") {
                            return caches.delete(cacheName);
                        }
                    })
                );
            })
            .then(() => self.clients.claim())
    );
});

self.addEventListener("message", (event) => {
    if (event.data.action === "skipWaiting") {
        self.skipWaiting();
    }
});
