(function($) {
	"use strict";
		
	// ______________ Cover-image
	$(".cover-image").each(function() {
		var attr = $(this).attr('data-image-src');
		if (typeof attr !== typeof undefined && attr !== false) {
			$(this).css('background', 'url(' + attr + ') center center');
		}
	});
	
	// ______________ Global Loader
	$(window).on("load", function(e) {
		$("#global-loader").fadeOut("slow");
	})
	
	// ______________ Color-skin
	$(document).ready(function() {
      $("a[data-theme]").click(function() {
        $("head link#theme").attr("href", $(this).data("theme"));
        $(this).toggleClass('active').siblings().removeClass('active');
      });
      $("a[data-effect]").click(function() {
        $("head link#effect").attr("href", $(this).data("effect"));
        $(this).toggleClass('active').siblings().removeClass('active');
      });
    });
	
	
	// ______________ Modal
	$("#myModal").modal('show');
	
	
	// ______________Rating Stars
	var ratingOptions = {
		selectors: {
			starsSelector: '.rating-stars',
			starSelector: '.rating-star',
			starActiveClass: 'is--active',
			starHoverClass: 'is--hover',
			starNoHoverClass: 'is--no-hover',
			targetFormElementSelector: '.rating-value'
		}
	};
	$(".rating-stars").ratingStars(ratingOptions);
	
	//________Banner Slider Media Query
	$(document).ready(function(){
	    if (window.matchMedia('(max-width: 991px)').matches) {
            $("#HomeBanner").removeClass("slider slider-header");
            $("#HomeBanner").parent().addClass("container");
        } else {
            $("#HomeBanner").addClass("slider slider-header");
            $("#HomeBanner").parent().removeClass("container");
        }
	});
	
	$(document).ready(function() {
	    $(".mapModal").click(function(){
            $("#setLocation").css('display','flex');
	    });
	});
	
	// lazload progressively
    let imagesToLoad = document.querySelectorAll('img[data-src]');
    let loadImages = (image) => {
    	image.setAttribute('src', image.getAttribute('data-src'));
    	image.onload = () => {
    		image.removeAttribute('data-src');
    	};
    };
    if('IntersectionObserver' in window) {
    	let observer = new IntersectionObserver((items, observer) => {
    		items.forEach((item) => {
    			if(item.isIntersecting) {
    				loadImages(item.target);
    				observer.unobserve(item.target);
    			}
    		});
    	});
    	imagesToLoad.forEach((img) => {
    		observer.observe(img);
    	});
    } else {
    	imagesToLoad.forEach((img) => {
    		loadImages(img);
    	});
    }
	
		
})(jQuery);	