<?php

namespace App\Http\Controllers;

use App\Models\Banner;
use App\Models\Product;
use App\Models\News;
use App\Models\State;
use App\Models\Examcity as Examcenter;
use App\Models\District;
use App\Models\Events;
use App\Models\Review;
use App\Models\Scholarship;
use App\Models\Volunteer;
use App\Models\Donate;
use App\Models\Donation;
use App\Models\Sport;
use App\Models\Agriculture;
use App\Models\Career;
use App\Models\Contact;
use App\Models\Dynamic;
use App\Models\Gallery;
use App\Models\Partner;
use App\Models\Industry;
use App\Models\Setting;
use App\Models\User;
use App\Models\Membership;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\VolunteerWelcomeMail;
// use Hash;/

class HomeController extends Controller
{

    public function index()
    {
        $gallery = Gallery::where('status', '1')->where('home', '1')->get();
        $partner = Partner::where('status', '1')->where('home', '1')->get();
        $banner = Banner::where('status', '1')->get();
        $projects = Product::where('status', '1')->limit(6)->get();
        $testimonials = Review::where('status', '1')->where('home', '1')->get();
        $settings = Setting::whereId(1)->first();
        $news = News::where('status', '1')->orderBy('id', 'desc')->get();

        return view("index", compact('settings', 'gallery', 'partner', 'banner', 'projects', 'testimonials', 'news'));
    }

    public function about()
    {
        $dynamic = Dynamic::where('slug', 'about-us')->where('status', 1)->first();
        return view("about-us", compact('dynamic'));
    }


    public function gallery()
    {
        $dynamic = Dynamic::where('slug', 'gallery')->where('status', 1)->first();
        $gallery = Gallery::where('status', '1')->get();

        return view("gallery", compact('gallery', 'dynamic'));
    }



    public function testimonials()
    {
        $dynamic = Dynamic::where('slug', 'testimonials')->where('status', 1)->first();
        $testimonials = Review::where('status', '1')->get();

        return view("testimonials", compact('testimonials', 'dynamic'));
    }



    public function project()
    {
        $dynamic = Dynamic::where('slug', 'project')->where('status', 1)->first();
        $projects = Product::where('status', '1')->get();

        return view("project", compact('projects', 'dynamic'));
    }


    public function projectDetails($slug)
    {
        $project = Product::where('status', '1')->where('slug', $slug)->first();
        if ($project) {
            $settings = Setting::whereId(1)->first();

            $states = [];
            if ($project->slug == "sports" || $project->slug == "agriculture") {
                $states = State::where('status', 'Active')->get();
            }

            return view("project-details", compact('project', 'settings', 'states'));
        } else {
            abort(404);
        }
    }


    public function submitsports(Request $request)
    {
        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $errors['email'] = 'required|email|max:250';

        $validatedData = $request->validate($errors); // all fields validation

        $validatedData['ipaddress'] = $request->ip();
        $validatedData['browser'] = $_SERVER['HTTP_USER_AGENT'];

        $time = time();



        Sport::create($validatedData); // saving the data


        return back()->with('success', 'Submited Succesfully.');
    }


    public function submitagriculture(Request $request)
    {
        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation

        $validatedData['ipaddress'] = $request->ip();
        $validatedData['browser'] = $_SERVER['HTTP_USER_AGENT'];

        $time = time();



        Agriculture::create($validatedData); // saving the data


        return back()->with('success', 'Submited Succesfully.');
    }


    public function news()
    {

        $dynamic = Dynamic::where('slug', 'news')->where('status', 1)->first();
        $news = News::where('status', '1')->orderBy('id', 'desc')->get();

        return view("news", compact('news', 'dynamic'));
    }


    public function newsDetails($slug)
    {
        $news = News::where('status', '1')->where('slug', $slug)->first();
        if ($news) {
            return view("news-details", compact('news'));
        } else {
            abort(404);
        }
    }



    public function events()
    {

        $dynamic = Dynamic::where('slug', 'events')->where('status', 1)->first();
        $events = Events::where('status', '1')->get();

        return view("events", compact('events', 'dynamic'));
    }


    public function eventsDetails($slug)
    {
        $events = Events::where('status', '1')->where('slug', $slug)->first();
        if ($events) {
            return view("events-details", compact('events'));
        } else {
            abort(404);
        }
    }


    public function industry()
    {
        $dynamic = Dynamic::where('slug', 'industry')->where('status', 1)->first();
        return view("industry", compact('dynamic'));
    }



    public function industryDetails($slug)
    {
        $industry = Industry::where('status', '1')->where('slug', $slug)->first();
        if ($industry) {
            return view("industry-details", compact('industry'));
        } else {
            abort(404);
        }
    }




    public function dynamicPage($page)
    {
        $page = Dynamic::where('slug', $page)->where('status', 1)->first();
        if ($page) {
            return view("dynamic", compact('page'));
        } else {
            abort(404);
        }
    }


    public function contact()
    {
        $contact = Dynamic::where('slug', 'contact')->where('status', 1)->first();
        $settings = Setting::whereId(1)->first();
        return view('contact-us', compact('settings'));
    }

    public function scholarship()
    {
        $exam_center = Examcenter::where('status', '1')->orderBy('name', 'asc')->get();
        $states = State::where('status', 'Active')->get();
        $scholarship = Dynamic::where('slug', 'scholarship')->where('status', 1)->first();
        $settings = Setting::whereId(1)->first();
        return view('scholarship', compact('settings', 'states', 'exam_center'));
    }



    public function submitscholarship(Request $request)
    {
        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $errors['email'] = 'required|email|max:250';

        $validatedData = $request->validate($errors); // all fields validation

        $request->validate([
            'reciept' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048',
        ], [
            'reciept.required' => 'Please select payemnt reciept to upload.',
            'reciept.mimes' => 'Only JPG, PNG, JPEG, GIF, SVG, and WebP images are allowed.',
            'reciept.max' => 'The maximum allowed file size is 2048 KB.',
        ]);

        $validatedData['ipaddress'] = $request->ip();
        $validatedData['browser'] = $_SERVER['HTTP_USER_AGENT'];

        $time = time();

        $reciept = $request->file('reciept');
        if (isset($reciept) && !empty($reciept)) {


            $recieptname = 'reciept1_' . $time . '.' . $reciept->extension();
            $recieptname2 = 'reciept2_' . $time . '.webp';
            $destinationPath = public_path('/scholarship/');

            $request->reciept->move($destinationPath . '/reciept/', $recieptname); // for reciept

            // Resize and optimize the image using Intervention/Image package
            $recieptimg = Image::make($destinationPath . '/reciept/' . $recieptname);
            $recieptimg->encode('webp');
            $recieptimg->save($destinationPath . '/reciept/' . $recieptname2);
            unlink($destinationPath . '/reciept/' . $recieptname);

            $validatedData['reciept'] = $recieptname2;
        }


        Scholarship::create($validatedData); // saving the data


        return back()->with('success', 'Submited Succesfully.');
    }


    public function submitdonate(Request $request)
    {
        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $errors['email'] = 'required|email|max:250';

        $validatedData = $request->validate($errors); // all fields validation

        $request->validate([
            'reciept' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048',
        ], [
            'reciept.required' => 'Please select payemnt reciept to upload.',
            'reciept.mimes' => 'Only JPG, PNG, JPEG, GIF, SVG, and WebP images are allowed.',
            'reciept.max' => 'The maximum allowed file size is 2048 KB.',
        ]);

        $validatedData['ipaddress'] = $request->ip();
        $validatedData['browser'] = $_SERVER['HTTP_USER_AGENT'];

        $time = time();

        $reciept = $request->file('reciept');
        if (isset($reciept) && !empty($reciept)) {


            $recieptname = 'reciept1_' . $time . '.' . $reciept->extension();
            $recieptname2 = 'reciept2_' . $time . '.webp';
            $destinationPath = public_path('/donate/');

            $request->reciept->move($destinationPath . '/reciept/', $recieptname); // for reciept

            // Resize and optimize the image using Intervention/Image package
            $recieptimg = Image::make($destinationPath . '/reciept/' . $recieptname);
            $recieptimg->encode('webp');
            $recieptimg->save($destinationPath . '/reciept/' . $recieptname2);
            unlink($destinationPath . '/reciept/' . $recieptname);

            $validatedData['reciept'] = $recieptname2;
        }


        Donate::create($validatedData); // saving the data


        return back()->with('success', 'Submited Succesfully.');
    }


    public function submitvolunteer(Request $request)
    {
        // Validate the request fields
        $validatedData = $request->validate([
            'name'           => 'required|string|max:255',
            'email'          => 'required|email|max:250',
            'phone'          => 'required|digits:10',
            'qualification'  => 'required|string|max:255',
            'dob'            => 'required|date',
            'address'        => 'required|string|max:500',
            'message'        => 'required|string|max:1000',
            'profile_image'  => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'password'       => 'required|string|min:6',
            'Confirm_password' => 'required|string|min:6',
        ]);

        // Check if password and confirm password match
        if ($request->password !== $request->Confirm_password) {
            return back()->withErrors(['Confirm_password' => 'Password and Confirm Password do not match.'])->withInput();
        }

        // Add generated and server-side fields
        $validatedData['ipaddress'] = $request->ip();
        $validatedData['browser'] = $request->header('User-Agent');

        // ✅ Generate Registration ID
        $validatedData['rid'] = 'VOL' . time() . rand(100, 999);
        $fullUrl = '';
        // ✅ Handle image upload
        if ($request->hasFile('profile_image')) {
            $image = $request->file('profile_image');
            $filename = time() . '_' . uniqid() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/volunteers'), $filename);
            $fullUrl = url('public/uploads/volunteers/' . $filename);
            $validatedData['image'] = $fullUrl; // Make sure DB column is `image`
        }

        unset($validatedData['profile_image']);
        unset($validatedData['password']);
        unset($validatedData['Confirm_password']);

        // Save to database
        Volunteer::create($validatedData);

        $userData = [
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'phone' => $request->phone,
            'photo' => $fullUrl,
            'status' => 1,
            'role' => 'volunteer'
        ];

        User::create($userData);

        // ✅ Send Welcome Email
        // Mail::to($request->email)->send(new VolunteerWelcomeMail($request->name, $request->email));

        return back()->with('success', 'Submitted Successfully.');
    }


    public function donate()
    {
        $settings = Setting::whereId(1)->first();
        return view('donate', compact('settings'));
    }


    public function volunteer()
    {
        $volunteer = Dynamic::where('slug', 'volunteer')->where('status', 1)->first();
        $settings = Setting::whereId(1)->first();
        return view('volunteer', compact('settings'));
    }


    public function district(Request $request)
    {
        $state_id = $request->state_id;
        $district = District::where('state_id', $state_id)->where('district_status', 'Active')->get();
        echo "<option value=''>Select Now</option>";
        foreach ($district as $item) {
            echo "<option value='";
            echo $item->districtid;
            echo "'>";
            echo $item->district_title;
            echo "</option>";
        }
    }


    public function sendContactForm(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|max:250',
            'mobile' => 'required|max:250',
            'email' => 'required|email|max:250',
            'message' => 'required',
        ]);

        $validatedData['ipaddress'] = $request->ip();
        $validatedData['browser'] = $_SERVER['HTTP_USER_AGENT'];

        Contact::create($validatedData);

        return back()->with('success', 'Thank You for connecting with us.');
    }


    public function idCard()
    {
        $volunteer = null;
        if (session()->has('user_data') && session('user_data')->role == 'volunteer') {
            $userEmail = session('user_data')->email ?? null;
            if ($userEmail) {
                $volunteer = Volunteer::where('email', $userEmail)->first();
            }
        }
        $settings = Setting::first();
        return view("admin.idcard", compact('volunteer','settings'));
    }


    public function certificate()
    {
        $volunteer = null;
        if (session()->has('user_data') && session('user_data')->role == 'volunteer') {
            $userEmail = session('user_data')->email ?? null;
            if ($userEmail) {
                $volunteer = Volunteer::where('email', $userEmail)->first();
            }
        }
        $settings = Setting::first();
        return view("admin.certificate", compact('volunteer', 'settings'));
    }


    public function verify(Request $request)
    {
        $id = $request->get('id');
        $volunteer = Volunteer::find($id);

        if ($volunteer) {
            return view('verify', compact('volunteer'));
        } else {
            return view('verify-not-found');
        }
    }


    public function membershipForm()
    {
        $volunteer = null;
        $membership = null;
        $donation = null;

        if (session()->has('user_data') && session('user_data')->role == 'volunteer') {
            $userEmail = session('user_data')->email ?? null;

            if ($userEmail) {
                $volunteer = Volunteer::where('email', $userEmail)->first();

                // check membership applied by email
                $membership = Membership::where('email', $userEmail)->latest()->first();

                // if applied, check payment for membership fee
                if ($membership && $volunteer) {
                    $donation = Donation::where('email', $userEmail)
                        ->where('payment_type', 'membership')
                        ->latest()
                        ->first();
                }
            }
        }

        $membershipFee = optional(Setting::first())->membership_fee ?? 0;

        return view("admin.membership", compact('volunteer', 'membership', 'donation', 'membershipFee'));
    }


    public function submitMembership(Request $request)
    {
        // Basic validation
        $request->validate([
            'pan_number'     => 'required|max:10',
            'aadhaar_number' => 'required|digits:12',
        ]);

        // Normalize PAN (convert any letters to uppercase)
        $panNumber = strtoupper($request->pan_number);

        // Save membership
        Membership::create([
            'name'           => $request->name,
            'email'          => $request->email,
            'phone'          => $request->phone,
            'dob'            => $request->dob,
            'qualification'  => $request->qualification,
            'address'        => $request->address,
            'pan_number'     => $panNumber,
            'aadhaar_number' => $request->aadhaar_number,
            'why_join'       => $request->why_join,
            'status'         => 'pending',
        ]);

        $type = "membership";

        // Fetch membership fee from settings table
        $settings = Setting::first(); // assuming single row table
        $amount = $settings->membership_fee ?? 0; // fallback 0 if null

        // Redirect to donation page with data in session flash
        return redirect('master/donation')
            ->with([
                'type' => $type,
                'amount' => $amount,
                'success' => 'Membership applied successfully! Now you can donate.'
            ]);
    }


    public function donation(Request $request)
    {
        $settings = Setting::first();
        return view("admin.donation", compact('settings'));
    }


    public function submitDonation(Request $request)
    {
        $request->validate([
            'payment_type' => 'required',
            'utr_number'   => 'required',
            'screenshot'   => 'required|image',
            'amount'       => 'required|numeric|min:1',
        ]);

        $sessionUser = session('user_data');

        // DB se user fetch by email
        $user = User::where('email', $sessionUser->email)->first();

        if (!$user) {
            return redirect()->back()->with('error', 'User not found in database!');
        }

        // Screenshot upload
        $path = 'donations/payment_screenshot';
        $filename = time() . '_' . $request->file('screenshot')->getClientOriginalName();

        $request->file('screenshot')->move(public_path($path), $filename);

        // Save donation with user_id
        Donation::create([
            'user_id'      => $user->id,
            'name'         => $user->name,
            'email'        => $user->email,
            'phone'        => $user->phone ?? null,
            'payment_type' => $request->payment_type,
            'amount'       => $request->amount,
            'utr_number'   => $request->utr_number,
            'screenshot'   => $path . '/' . $filename, // ✅ directly in public folder
            'status'       => 'pending',
        ]);

        // return redirect()->back()->with('success', 'Donation submitted successfully!');
        return redirect('master/donation/payment-history')->with('success', 'Donation submitted successfully!');
    }


    public function updateStatus(Request $request)
    {
        $donation = Donation::find($request->id);

        if ($donation) {
            $donation->status = $request->status; // pending / confirmed / rejected
            $donation->save();

            // Update membership status based on donation status
            $membership = Membership::where('email', $donation->email)
                ->where('phone', $donation->phone)
                ->first();

            if ($membership) {
                if ($donation->status == 'confirmed') {
                    $membership->status = 'active';
                } elseif ($donation->status == 'rejected') {
                    $membership->status = 'rejected';
                } else {
                    $membership->status = 'pending';
                }
                $membership->save();
            }

            return response()->json(['success' => true]);
        }

        return response()->json(['success' => false]);
    }


    public function showDonationReceipt(Request $request)
    {
        $sessionUser = session('user_data');

        if (!$sessionUser) {
            return redirect('/login')->with('error', 'Please login to view your donation receipt.');
        }

        $user = User::where('email', $sessionUser->email)->first();

        if (!$user) {
            return redirect()->back()->with('error', 'User not found.');
        }

        // check if any id query is present in the string
        if ($request->has('id')) {
            $donation = \App\Models\Donation::where('user_id', $user->id)
                ->where('payment_type', 'donation')
                ->where('id', $request->id)
                ->first();
        } else {
            // else fetch the latest record if id query is not presen.
            $donation = Donation::where('user_id', $user->id)
                ->where('payment_type', 'donation')
                ->latest()
                ->first();
        }

        return view('admin.donation_receipt', compact('user', 'donation'));
    }


    public function showMembershipReceipt()
    {
        $sessionUser = session('user_data'); // session se data lo

        if (!$sessionUser) {
            return redirect('/login')->with('error', 'Please login to view your membership receipt.');
        }

        // email se user fetch karo
        $user = User::where('email', $sessionUser->email)->first();

        if (!$user) {
            return redirect()->back()->with('error', 'User not found.');
        }

        // latest membership record fetch karo jiska type membership hai
        $donation = Donation::where('user_id', $user->id)
            ->where('payment_type', 'membership')
            ->latest()
            ->first();

        $membershipApplied = Membership::where('email', $user->email)->exists();

        $membershipFee = optional(Setting::first())->membership_fee ?? 0;

        return view('admin.membership_receipt', compact('user', 'donation', 'membershipApplied', 'membershipFee'));
    }


    public function appointmentLetter()
    {
        $user = session('user_data'); // logged in user's data
        return view('admin.appointment_letter', compact('user'));
    }


    public function paymentHistory()
    {
        $sessionUser = session('user_data');

        if (!$sessionUser) {
            return redirect('/login')->with('error', 'Please login to view your donation history.');
        }

        // fetch user using email
        $user = User::where('email', $sessionUser->email)->first();

        if (!$user) {
            return redirect()->back()->with('error', 'User not found.');
        }

        // then Fetch payment history of that specific user
        $donations = Donation::where('user_id', $user->id)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('admin.payment_history', compact('donations'));
    }
}