<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use DB;
use App\Models\Review;

use Illuminate\Http\Request;

class ReviewController extends Controller
{

    public function index()
    {
        $reviews = DB::table('reviews')->get();
        return view(config('app.admin.view') . '.review.index', compact('reviews'));
    }

    public function create()
    {
        return view(config('app.admin.view') . '.review.create');
    }

    public function store(Request $request)
    {
        $time = time();

        $input = array_keys($request->input()); // all inputs
        $input = array_diff($input, ['_token', '_method']); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation

        $image = $request->file('image');
        if (isset($image) && !empty($image)) {
            $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);


            $imagename = $validatedData['name'] . '_img_1' . $time . '.' . $image->extension();
            $destinationPath = storage_path('../public/review/');
            $path = 'review/image/' . $imagename;
            $request->image->move($destinationPath . '/image/', $imagename); // for grid
            $validatedData['image'] = $path;
        }

        $review_image = $request->file('review_image');
        if (isset($review_image) && !empty($review_image)) {
            $request->validate(['review_image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);


            $review_imagename = $validatedData['name'] . '_review_image_1_' . $time . '.' . $review_image->extension();
            $destinationPath = storage_path('../public/scorecard/');
            $path = 'review/review_image/' . $review_imagename;
            $request->review_image->move($destinationPath . '/review_image/', $review_imagename); // for review_image
            $validatedData['review_image'] = $path;

        }


       

        DB::table('reviews')->insert($validatedData); // saving the data

        return back()->with('success', 'Review added successfully');

    }

    public function edit($id)
    {
        $id = decrypt($id);


        $review = DB::table('reviews')->where('id', $id)->first();
        return view(config('app.admin.view') . '.review.edit', compact('review'));
    }

    public function update(Request $request, $id)
    {
        $xid = decrypt($id);
        $time = time();

        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 2); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation
        $destinationPath = storage_path('../public/review/');

        $image = $request->file('image');

        $validatedData['image'] = Review::whereId($xid)->pluck('image')->first();
        if (!empty($image)) {
            $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

            if (!empty($validatedData['image']) && file_exists(public_path($validatedData['image']))) {
                unlink(public_path($validatedData['image']));
            }

            $imagename = $validatedData['name'] . '_img_1' . $time . '.' . $image->extension();
            $request->image->move($destinationPath . '/image/', $imagename); // for grid
            $path = 'review/image/' . $imagename;
            $validatedData['image'] = $path;

        }

        $review_image = $request->file('review_image');
            $validatedData['review_image'] = DB::table('reviews')->where('id', $id)->pluck('review_image')->first();
            if (!empty($review_image)) {
                $request->validate(['review_image' => 'required|mimes:review_image,review_image|max:15048']);
                if (file_exists(public_path($validatedData['review_image']))) {
                    unlink(public_path($validatedData['review_image']));
                }

                $review_imagename = $validatedData['name'] . '_1' . $time . '.' . $review_image->extension();
                $request->review_image->move($destinationPath . '/review_image/', $review_imagename); // for grid
                $path = 'scorecard/review_image/' . $review_imagename;
                $validatedData['review_image'] = $path;

        }



        Review::whereId($xid)->update($validatedData); // saving the data

        return back()->with('success', 'Review has been updated');
    }

    public function destroy($id)
    {
        $xid = decrypt($id);

        $image = Review::whereId($xid)->pluck('image')->first();
        if (file_exists(public_path($image)) && $image != "") {
            unlink(public_path($image));
        }
      

        $review = Review::whereId($xid)->delete();

        return back()->with('success', 'Review has been deleted');
    }
}
