<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Partner;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class PartnerController extends Controller
{

    public function index()
    {
        return view(config('app.admin.view') . '.partner.index', ['partners' => Partner::all()]);
    }

    public function create()
    {
        return view(config('app.admin.view') . '.partner.create');
    }

    public function store(Request $request)
    {
        $time = time();

        $input = array_keys($request->input()); // all inputs
        $input = array_diff($input, ['_token', '_method']); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation
        $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

        $image = $request->file('image');
        if (isset($image) && !empty($image)) {

            $imagename = \Str::slug($validatedData['title']) . '_img_1' . $time . '.' . $image->extension();
            $imagename2 = \Str::slug($validatedData['title']) . '_img_2' . $time . '.webp';
            $destinationPath = public_path('/assets/partner/');
            $request->image->move($destinationPath , $imagename); // for grid
            $validatedData['image'] = $imagename2;
        }

        Partner::create($validatedData);

        if (isset($image) && !empty($image)) {
            // Resize and optimize the image using Intervention/Image package
            $img = Image::make($destinationPath . $imagename);
            $img->encode('webp');
            $img->save($destinationPath . $imagename2);

            unlink($destinationPath . $imagename);
        }

        return redirect(config('app.admin.route') . '/partner/create')->with('success', 'Partner added successfully');

    }

    public function show($id)
    {
        $id = decrypt($id);
        $partner = Partner::find($id);

        return view(config('app.admin.view') . '.partner.show', compact('partner'));
    }

    public function edit($id)
    {
        $id = decrypt($id);
        $partner = Partner::find($id);

        return view(config('app.admin.view') . '.partner.edit', compact('partner'));
    }

    public function update(Request $request, $id)
    {
        $xid = decrypt($id);
        $time = time();

        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 2); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required


        $validatedData = $request->validate($errors); // all fields validation
        $destinationPath = public_path('/assets/partner/');

        $image = $request->file('image');
        $validatedData['image'] = Partner::whereId($xid)->pluck('image')->first();
        if (!empty($image)) {
            $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

            if (file_exists($destinationPath . $validatedData['image'])) {
                unlink($destinationPath . $validatedData['image']);
            }

            $imagename = \Str::slug($validatedData['title']) . '_img_1' . $time . '.' . $image->extension();
            $imagename2 = \Str::slug($validatedData['title']) . '_img_2' . $time . '.webp';
            $request->image->move($destinationPath , $imagename); // for grid
            $validatedData['image'] = $imagename2;

            // Resize and optimize the image using Intervention/Image package
            $img = Image::make($destinationPath . $imagename);
            // Resize and store the image for the meta image


            // Resize and store the image for the meta image
            $img->encode('webp', 100);
            $img->save($destinationPath . $imagename2);

            unlink($destinationPath . $imagename);

        }

        
        Partner::whereId($xid)->update($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/partner/edit/' . $id)->with('success', 'Partner has been updated');
    }

    public function destroy($id)
    {
        $id = decrypt($id);
        $partner = Partner::find($id);
        $partner->delete();

        return redirect(config('app.admin.route') . '/partner')->with('success', 'Partner has been deleted');
    }
}
