<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Gallery;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class GalleryController extends Controller
{

    public function index()
    {
        return view(config('app.admin.view') . '.gallery.index', ['gallerys' => Gallery::all()]);
    }

    public function create()
    {
        return view(config('app.admin.view') . '.gallery.create');
    }

    public function store(Request $request)
    {
        $time = time();

        $input = array_keys($request->input()); // all inputs
        $input = array_diff($input, ['_token', '_method']); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation
        $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

        $image = $request->file('image');
        if (isset($image) && !empty($image)) {

            $imagename = \Str::slug($validatedData['title']) . '_img_1' . $time . '.' . $image->extension();
            $imagename2 = \Str::slug($validatedData['title']) . '_img_2' . $time . '.webp';
            $destinationPath = public_path('/assets/gallery/');
            $request->image->move($destinationPath , $imagename); // for grid
            $validatedData['image'] = $imagename2;
        }

        Gallery::create($validatedData);

        if (isset($image) && !empty($image)) {
            // Resize and optimize the image using Intervention/Image package
            $img = Image::make($destinationPath . $imagename);
            $img->resize(900, 600)->encode('webp');
            $img->save($destinationPath . $imagename2);

            unlink($destinationPath . $imagename);
        }

        return redirect(config('app.admin.route') . '/gallery/create')->with('success', 'Gallery added successfully');

    }

    public function show($id)
    {
        $id = decrypt($id);
        $gallery = Gallery::find($id);

        return view(config('app.admin.view') . '.gallery.show', compact('gallery'));
    }

    public function edit($id)
    {
        $id = decrypt($id);
        $gallery = Gallery::find($id);

        return view(config('app.admin.view') . '.gallery.edit', compact('gallery'));
    }

    public function update(Request $request, $id)
    {
        $xid = decrypt($id);
        $time = time();

        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 2); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required


        $validatedData = $request->validate($errors); // all fields validation
        $destinationPath = public_path('/assets/gallery/');

        $image = $request->file('image');
        $validatedData['image'] = Gallery::whereId($xid)->pluck('image')->first();
        if (!empty($image)) {
            $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

            if (file_exists($destinationPath . $validatedData['image'])) {
                unlink($destinationPath . $validatedData['image']);
            }

            $imagename = \Str::slug($validatedData['title']) . '_img_1' . $time . '.' . $image->extension();
            $imagename2 = \Str::slug($validatedData['title']) . '_img_2' . $time . '.webp';
            $request->image->move($destinationPath , $imagename); // for grid
            $validatedData['image'] = $imagename2;

            // Resize and optimize the image using Intervention/Image package
            $img = Image::make($destinationPath . $imagename);
            // Resize and store the image for the meta image


            // Resize and store the image for the meta image
            $img->resize(900, 600)->encode('webp', 100);
            $img->save($destinationPath . $imagename2);

            unlink($destinationPath . $imagename);

        }

        
        Gallery::whereId($xid)->update($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/gallery/edit/' . $id)->with('success', 'Gallery has been updated');
    }

    public function destroy($id)
    {
        $id = decrypt($id);
        $gallery = Gallery::find($id);
        $gallery->delete();

        return redirect(config('app.admin.route') . '/gallery')->with('success', 'Gallery has been deleted');
    }
}
