<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class BannerController extends Controller
{

    public function index()
    {
        return view(config('app.admin.view') . '.banner.index', ['banners' => Banner::all()]);
    }

    public function create()
    {
        return view(config('app.admin.view') . '.banner.create');
    }

    public function store(Request $request)
    {
        $time = time();

        $input = array_keys($request->input()); // all inputs
        $input = array_diff($input, ['_token', '_method']); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        // removing required from optional field
        $errors = array_merge($errors, array_fill_keys(['applicable_fee','link','linktext','link2','linktext2'], ""));

        $validatedData = $request->validate($errors); // all fields validation
        $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

        $image = $request->file('image');
        if (isset($image) && !empty($image)) {

            $imagename = \Str::slug($validatedData['title']) . '_img_1' . $time . '.' . $image->extension();
            $imagename2 = \Str::slug($validatedData['title']) . '_img_2' . $time . '.webp';
            $destinationPath = public_path('/assets/banner/');
            $request->image->move($destinationPath , $imagename); // for grid
            $validatedData['image'] = $imagename2;
        }

        Banner::create($validatedData);

        if (isset($image) && !empty($image)) {
            // Resize and optimize the image using Intervention/Image package
            $img = Image::make($destinationPath . $imagename);
            $img->resize(1920, 800)->encode('webp');
            $img->save($destinationPath . $imagename2);

            unlink($destinationPath . $imagename);
        }

        return redirect(config('app.admin.route') . '/banner/create')->with('success', 'Banner added successfully');

    }

    public function show($id)
    {
        $id = decrypt($id);
        $banner = Banner::find($id);

        return view(config('app.admin.view') . '.banner.show', compact('banner'));
    }

    public function edit($id)
    {
        $id = decrypt($id);
        $banner = Banner::find($id);

        return view(config('app.admin.view') . '.banner.edit', compact('banner'));
    }

    public function update(Request $request, $id)
    {
        $xid = decrypt($id);
        $time = time();

        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 2); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        // removing required from optional field
        $errors = array_merge($errors, array_fill_keys(['applicable_fee', 'link', 'linktext', 'link2', 'linktext2'], ""));

        $validatedData = $request->validate($errors); // all fields validation
        $destinationPath = public_path('/assets/banner/');

        $image = $request->file('image');
        $validatedData['image'] = Banner::whereId($xid)->pluck('image')->first();
        if (!empty($image)) {
            $request->validate(['image' => 'required|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

            if (file_exists($destinationPath . $validatedData['image'])) {
                unlink($destinationPath . $validatedData['image']);
            }

            $imagename = \Str::slug($validatedData['title']) . '_img_1' . $time . '.' . $image->extension();
            $imagename2 = \Str::slug($validatedData['title']) . '_img_2' . $time . '.webp';
            $request->image->move($destinationPath , $imagename); // for grid
            $validatedData['image'] = $imagename2;

            // Resize and optimize the image using Intervention/Image package
            $img = Image::make($destinationPath . $imagename);
            // Resize and store the image for the meta image


            // Resize and store the image for the meta image
            $img->resize(1920, 800)->encode('webp', 100);
            $img->save($destinationPath . $imagename2);

            unlink($destinationPath . $imagename);

        }

        
        Banner::whereId($xid)->update($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/banner/edit/' . $id)->with('success', 'Banner has been updated');
    }

    public function destroy($id)
    {
        $id = decrypt($id);
        $banner = Banner::find($id);
        $banner->delete();

        return redirect(config('app.admin.route') . '/banner')->with('success', 'Banner has been deleted');
    }
}
