<?php

// print_r($cibil->response);
// die;
// Parse the CIBIL report response
function parseCibilResponse($responseData) {
    $decoded = json_decode($responseData, true);
    return $decoded['cibilReport']['data']['cCRResponse']['cIRReportDataLst'][0]['cIRReportData'] ?? null;
}

// Sample data - replace $responseData with your actual response
$responseData = $cibil->response;

$report = parseCibilResponse($responseData);

// User data
$userData = [
    'id' => 2,
    'user_id' => 1,
    'full_name' => 'Lov Prakash',
    'mobile' => '9835153380',
    'pan' => 'CBZPP2003E',
    'dob' => '1993-06-08',
    'address' => 'Mahamadpur Dariya',
    'pincode' => '844118'
];

function getScoreRange($score) {
    if ($score >= 300 && $score <= 550) {
        return ['label' => 'Poor', 'color' => '#E42127'];
    } elseif ($score >= 551 && $score <= 650) {
        return ['label' => 'Average', 'color' => '#F19118'];
    } elseif ($score >= 651 && $score <= 750) {
        return ['label' => 'Good', 'color' => '#B2AE0D'];
    } elseif ($score >= 751 && $score <= 900) {
        return ['label' => 'Excellent', 'color' => '#0B9547'];
    } else {
        return ['label' => 'Unknown', 'color' => '#6c757d'];
    }
}

function formatDate($date) {
    return date('d/m/Y', strtotime($date));
}

function formatTime($time) {
    return date('h:i A', strtotime($time));
}

function getPaymentStatusColor($status) {
    switch($status) {
        case '000': case 'NEW': case 'STD': return 'bg-success text-white';
        case '01+': case '30+': return 'bg-warning text-dark';
        case '60+': case '90+': return 'bg-danger text-white';
        case '120+': return 'bg-dark text-white';
        case 'CLSD': return 'bg-secondary text-white';
        case '*': return 'bg-light text-muted';
        default: return 'bg-info text-white';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CIBIL Score Report</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
        }
        
        .page-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
        }
        
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.08);
            margin-bottom: 2rem;
            transition: all 0.3s ease;
            overflow: hidden;
        }
        
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 35px rgba(0,0,0,0.12);
        }
        
        .card-header {
            border-radius: 15px 15px 0 0 !important;
            font-weight: 600;
            padding: 1.5rem;
            border-bottom: none;
        }
        
        .card-body {
            padding: 2rem;
        }
        
        /* Enhanced spacing for different screen sizes */
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
            
            .row.mb-4 {
                margin-bottom: 2rem !important;
            }
            
            .col-md-3, .col-md-4, .col-md-6 {
                margin-bottom: 1rem;
            }
            
            .d-flex.p-3 {
                padding: 1rem !important;
                margin-bottom: 0.5rem;
            }
            
            .score-gauge {
                width: 150px !important;
                height: 150px !important;
            }
            
            .score-value {
                font-size: 2rem !important;
            }
        }
        
        @media (max-width: 576px) {
            .container-fluid {
                padding: 0 10px;
            }
            
            .card-body {
                padding: 1rem;
            }
            
            .page-header {
                padding: 1.5rem 0;
            }
            
            .display-6 {
                font-size: 1.5rem !important;
            }
        }
        
        /* Improved visual hierarchy */
        .bg-light {
            background-color: #f8f9fa !important;
            border: 1px solid #e9ecef;
        }
        
        .bg-opacity-10 {
            background-opacity: 0.1 !important;
        }
        
        /* Enhanced icon styling */
        .fs-4 {
            font-size: 1.5rem !important;
        }
        
        /* Consistent badge styling */
        .badge {
            font-weight: 500;
            padding: 0.5rem 0.75rem;
        }
        
        /* Better table responsiveness */
        .table-responsive {
            border-radius: 0.5rem;
            overflow: hidden;
        }
        
        .score-gauge {
            position: relative;
            width: 200px;
            height: 200px;
            margin: 0 auto;
        }
        
        .gauge-bg {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background: conic-gradient(
                #E42127 0deg 60deg,
                #F19118 60deg 120deg,
                #B2AE0D 120deg 180deg,
                #0B9547 180deg 240deg,
                #ddd 240deg 360deg
            );
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .gauge-inner {
            width: 80%;
            height: 80%;
            background: white;
            border-radius: 50%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .score-value {
            font-size: 2.5rem;
            font-weight: bold;
            margin: 0;
        }
        
        .score-label {
            font-size: 0.9rem;
            color: #6c757d;
            margin: 0;
        }
        
        .payment-history-cell {
            border: 1px solid #dee2e6;
            padding: 0.75rem 0.5rem;
            text-align: center;
            font-size: 0.8rem;
            min-height: 70px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            border-radius: 6px;
            margin: 2px;
            transition: all 0.2s ease;
            position: relative;
            overflow: hidden;
        }
        
        .payment-history-cell:hover {
            transform: scale(1.05);
            z-index: 10;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }
        
        .payment-status {
            font-weight: bold;
            margin-bottom: 0.25rem;
            font-size: 0.9rem;
        }
        
        .payment-month {
            color: #6c757d;
            font-size: 0.7rem;
            opacity: 0.8;
        }
        
        /* Enhanced payment status colors */
        .bg-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
        }
        
        .bg-warning {
            background: linear-gradient(135deg, #ffc107 0%, #fd7e14 100%) !important;
        }
        
        .bg-danger {
            background: linear-gradient(135deg, #dc3545 0%, #e83e8c 100%) !important;
        }
        
        .bg-info {
            background: linear-gradient(135deg, #17a2b8 0%, #6f42c1 100%) !important;
        }
        
        .bg-secondary {
            background: linear-gradient(135deg, #6c757d 0%, #495057 100%) !important;
        }
        
        .status-std { 
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
            color: #155724;
            border-color: #c3e6cb;
        }
        
        .status-30 { 
            background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
            color: #856404;
            border-color: #ffeaa7;
        }
        
        .status-60 { 
            background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
            color: #721c24;
            border-color: #f5c6cb;
        }
        
        .status-90 { 
            background: linear-gradient(135deg, #f5c6cb 0%, #f1b0b7 100%);
            color: #721c24;
            border-color: #f1b0b7;
        }
        
        /* Enhanced account summary styling */
        .account-summary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        /* Modern card effects */
        .card.border-start {
            border-left-width: 4px !important;
            transition: all 0.3s ease;
        }
        
        .card.border-start:hover {
            border-left-width: 8px !important;
            transform: translateX(5px);
        }
        
        /* Enhanced typography */
        h1, h2, h3, h4, h5, h6 {
            font-weight: 600;
            letter-spacing: -0.025em;
        }
        
        .display-6 {
            font-weight: 700;
            letter-spacing: -0.05em;
        }
        
        /* Improved spacing utilities */
        .mb-4 {
            margin-bottom: 2rem !important;
        }
        
        .p-3 {
            padding: 1.5rem !important;
        }
        
        /* Enhanced button styling */
        .btn {
            border-radius: 10px;
            font-weight: 500;
            letter-spacing: 0.025em;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        }
        
        /* Subtle animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .card {
            animation: fadeInUp 0.6s ease-out;
        }
        
        .card:nth-child(2) { animation-delay: 0.1s; }
        .card:nth-child(3) { animation-delay: 0.2s; }
        .card:nth-child(4) { animation-delay: 0.3s; }
        .card:nth-child(5) { animation-delay: 0.4s; }
        
        .print-hide {
            display: block;
        }
        
        @media print {
            .print-hide {
                display: none !important;
            }
            
            body {
                background: white !important;
                font-size: 12px !important;
                line-height: 1.4 !important;
            }
            
            .container-fluid {
                padding: 0 !important;
            }
            
            .card {
                box-shadow: none !important;
                border: 1px solid #ddd !important;
                break-inside: avoid !important;
                page-break-inside: avoid !important;
                margin-bottom: 15px !important;
            }
            
            .card-header {
                break-after: avoid !important;
                page-break-after: avoid !important;
            }
            
            .card-body {
                break-inside: avoid !important;
                page-break-inside: avoid !important;
            }
            
            .row {
                break-inside: avoid !important;
                page-break-inside: avoid !important;
                margin-bottom: 10px !important;
            }
            
            .page-header {
                background: #667eea !important;
                color: white !important;
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
                break-after: page !important;
                page-break-after: always !important;
            }
            
            .payment-history-cell {
                font-size: 10px !important;
                min-height: 40px !important;
                padding: 0.25rem !important;
            }
            
            .score-gauge {
                width: 150px !important;
                height: 150px !important;
            }
            
            .score-value {
                font-size: 2rem !important;
            }
            
            .bg-primary, .bg-info, .bg-warning, .bg-success, .bg-danger {
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            
            /* Force page breaks for better organization */
            .card:nth-child(3) {
                page-break-before: always !important;
            }
            
            .card:nth-child(6) {
                page-break-before: always !important;
            }
            
            /* Ensure tables don't break awkwardly */
            .table {
                font-size: 11px !important;
            }
            
            .table td, .table th {
                padding: 0.25rem !important;
            }
            
            /* Improve badge readability in print */
            .badge {
                border: 1px solid #333 !important;
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
        }
    </style>
</head>
<body>
    <!-- Page Header -->
    <div class="page-header">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h1 class="display-6 mb-0">
                        <i class="fas fa-chart-line me-3"></i>
                        CIBIL Score Report
                    </h1>
                    <p class="lead mb-0">Comprehensive Credit Information Bureau Report</p>
                </div>
                <div class="col-md-4 text-end print-hide">
                    <!--<button class="btn btn-light btn-lg me-2" onclick="window.print()">-->
                    <!--    <i class="fas fa-print me-2"></i>Print-->
                    <!--</button>-->
                    <button class="btn btn-outline-light btn-lg" onclick="generatePDF()">
                        <i class="fas fa-file-pdf me-2"></i>Save PDF
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid" id="reportContent">
        <div class="row justify-content-center">
            <div class="col-xl-10">
                <!-- Personal Details Card -->
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-user me-2"></i>
                            Personal Details
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Personal Information -->
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <strong>Full Name:</strong><br>
                                <span class="text-muted"><?= $report['iDAndContactInfo']['personalInfo']['name']['fullName'] ?? 'N/A' ?></span>
                            </div>
                            <div class="col-md-3">
                                <strong>Date of Birth:</strong><br>
                                <span class="text-muted"><?= formatDate($report['iDAndContactInfo']['personalInfo']['dateOfBirth'] ?? '') ?></span>
                            </div>
                            <div class="col-md-3">
                                <strong>Gender:</strong><br>
                                <span class="text-muted"><?= $report['iDAndContactInfo']['personalInfo']['gender'] ?? 'N/A' ?></span>
                            </div>
                            <div class="col-md-3">
                                <strong>Age:</strong><br>
                                <span class="text-muted"><?= $report['iDAndContactInfo']['personalInfo']['age']['age'] ?? 'N/A' ?> years</span>
                            </div>
                        </div>
                        
                        <!-- Contact Information -->
                        <div class="row mb-4">
                            <?php if (!empty($report['iDAndContactInfo']['identityInfo']['pANId'])): ?>
                            <div class="col-md-3">
                                <strong>PAN Number:</strong><br>
                                <span class="text-muted"><?= $report['iDAndContactInfo']['identityInfo']['pANId'][0]['idNumber'] ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($report['iDAndContactInfo']['phoneInfo'])): ?>
                            <div class="col-md-3">
                                <strong>Phone:</strong><br>
                                <span class="text-muted"><?= $report['iDAndContactInfo']['phoneInfo'][0]['number'] ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($report['iDAndContactInfo']['emailAddressInfo'])): ?>
                            <div class="col-md-3">
                                <strong>Email:</strong><br>
                                <span class="text-muted"><?= $report['iDAndContactInfo']['emailAddressInfo'][0]['emailAddress'] ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($report['iDAndContactInfo']['addressInfo'])): ?>
                            <div class="col-md-3">
                                <strong>Address Type:</strong><br>
                                <span class="text-muted"><?= $report['iDAndContactInfo']['addressInfo'][0]['type'] ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Address Information -->
                        <?php if (!empty($report['iDAndContactInfo']['addressInfo'])): ?>
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <strong>Address:</strong><br>
                                <span class="text-muted">
                                    <?= $report['iDAndContactInfo']['addressInfo'][0]['address'] ?>, 
                                    <?= $report['iDAndContactInfo']['addressInfo'][0]['state'] ?> - 
                                    <?= $report['iDAndContactInfo']['addressInfo'][0]['postal'] ?>
                                </span>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Account Summary Section -->
                        <hr class="my-4">
                        <h6 class="text-primary mb-3">
                            <i class="fas fa-chart-pie me-2"></i>
                            Account Summary
                        </h6>
                        
                        <?php $summary = $report['retailAccountsSummary']; ?>
                        <div class="row mb-3">
                            <div class="col-md-3">
                                <div class="d-flex align-items-center p-3 bg-light rounded">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-credit-card text-primary fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <strong>Total Accounts:</strong><br>
                                        <span class="text-muted h5 mb-0"><?= $summary['noOfAccounts'] ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="d-flex align-items-center p-3 bg-light rounded">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-check-circle text-success fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <strong>Active Accounts:</strong><br>
                                        <span class="text-muted h5 mb-0"><?= $summary['noOfActiveAccounts'] ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="d-flex align-items-center p-3 bg-light rounded">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-exclamation-triangle text-warning fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <strong>Write Offs:</strong><br>
                                        <span class="text-muted h5 mb-0"><?= $summary['noOfWriteOffs'] ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="d-flex align-items-center p-3 bg-light rounded">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-clock text-danger fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <strong>Past Due Accounts:</strong><br>
                                        <span class="text-muted h5 mb-0"><?= $summary['noOfPastDueAccounts'] ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Financial Summary -->
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 bg-light bg-opacity-10 rounded">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-money-bill-wave text-danger fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <strong>Total Past Due:</strong><br>
                                        <span class="text-danger h5 mb-0">₹<?= number_format($summary['totalPastDue']) ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 bg-light bg-opacity-10 rounded">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-balance-scale text-info fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <strong>Total Balance:</strong><br>
                                        <span class="text-info h5 mb-0">₹<?= number_format($summary['totalBalanceAmount']) ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 bg-light bg-opacity-10 rounded">
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-hand-holding-usd text-success fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <strong>Total Sanction:</strong><br>
                                        <span class="text-success h5 mb-0">₹<?= number_format($summary['totalSanctionAmount']) ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Status Badge -->
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <div class="p-3 bg-warning bg-opacity-10 rounded">
                                    <strong>Most Severe Status (24M):</strong>
                                    <span class="badge bg-warning text-dark ms-2 fs-6"><?= $summary['mostSevereStatusWithIn24Months'] ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
   


        <!-- CIBIL Score Card -->
        <div class="card">
            <div class="card-header account-summary">
                <h5 class="mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    Credit Score & Risk Analysis
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php 
                    $scoreDetails = $report['scoreDetails'];
                    foreach ($scoreDetails as $index => $score): 
                        $cibilScore = (int)$score['value'];
                        $scoreRange = getScoreRange($cibilScore);
                    ?>
                    <div class="col-md-6 text-center">
                        <div class="card">
                            <div class="card-body">
                                <!-- Score Gauge -->
                                <div class="score-gauge mb-4">
                                    <div class="gauge-bg">
                                        <div class="gauge-inner">
                                            <p class="score-value" style="color: <?= $scoreRange['color'] ?>"><?= $cibilScore ?></p>
                                            <p class="score-label"><?= $scoreRange['label'] ?></p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Score Details -->
                                <div class="badge p-3 mb-3" style="background-color: <?= $scoreRange['color'] ?>; color: white; font-size: 1rem;">
                                    <?= $scoreRange['label'] ?> Score
                                </div>
                                
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Score Type</strong></td>
                                            <td><?= $score['type'] ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Version</strong></td>
                                            <td><?= $score['version'] ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Score Name</strong></td>
                                            <td><?= $score['name'] ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Score Value</strong></td>
                                            <td><strong style="color: <?= $scoreRange['color'] ?>"><?= $cibilScore ?></strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                                
                                <!-- Scoring Elements -->
                                <?php if (!empty($score['scoringElements'])): ?>
                                <div class="mt-3">
                                    <h6>Risk Factors:</h6>
                                    <ul class="list-group list-group-flush">
                                        <?php foreach ($score['scoringElements'] as $element): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                            <div class="ms-2 me-auto">
                                                <div class="fw-bold">Code: <?= $element['code'] ?></div>
                                                <?= $element['description'] ?>
                                            </div>
                                            <span class="badge bg-primary rounded-pill"><?= $element['type'] ?></span>
                                        </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Account Information -->
        <div class="card">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-credit-card me-2"></i>
                    Account Information
                </h5>
            </div>
            <div class="card-body">
                <?php 
                $accounts = $report['retailAccountDetails'];
                foreach ($accounts as $index => $account): 
                ?>
                <div class="card mb-4 border-start border-4 border-<?= $account['open'] === 'Yes' ? 'success' : 'secondary' ?>">
                    <div class="card-header bg-light">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-md-3">
                                    <p><strong>Institution:</strong><br>
                                    <span class="text-primary fw-bold"><?= $account['institution'] ?></span><br>
                                    <small class="text-muted"><?= $account['accountType'] ?></small></p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Account Number:</strong><br>
                                    <span class="font-monospace"><?= $account['accountNumber'] ?></span></p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Current Balance:</strong><br>
                                    <span class="text-<?= $account['pastDueAmount'] > 0 ? 'danger' : 'success' ?> fw-bold">
                                        ₹<?= number_format($account['balance']) ?>
                                    </span>
                                    <?php if ($account['pastDueAmount'] > 0): ?>
                                        <br><small class="text-danger">Past Due: ₹<?= number_format($account['pastDueAmount']) ?></small>
                                    <?php endif; ?>
                                    </p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Sanction Amount:</strong><br>
                                    <span class="text-info fw-bold">₹<?= number_format($account['sanctionAmount']) ?></span></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <p><strong>Account Status:</strong><br>
                                    <span class="badge <?= $account['open'] === 'Yes' ? 'bg-success' : 'bg-secondary' ?> fs-6">
                                        <?= $account['open'] === 'Yes' ? 'Active' : 'Closed' ?>
                                    </span>
                                    <?php if (!empty($account['accountStatus'])): ?>
                                        <br><small class="text-muted"><?= $account['accountStatus'] ?></small>
                                    <?php endif; ?>
                                    </p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Ownership:</strong><br>
                                    <span><?= $account['ownershipType'] ?></span></p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Date Opened:</strong><br>
                                    <span><?= formatDate($account['dateOpened']) ?></span></p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Last Payment:</strong><br>
                                    <?php if (!empty($account['lastPayment'])): ?>
                                        <span class="text-success">₹<?= number_format($account['lastPayment']) ?></span><br>
                                        <small class="text-muted">on <?= formatDate($account['lastPaymentDate']) ?></small>
                                    <?php else: ?>
                                        <span class="text-muted">No recent payment</span>
                                    <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                            
                            <?php if (!empty($account['interestRate']) || !empty($account['installmentAmount'])): ?>
                            <div class="row">
                                <?php if (!empty($account['interestRate'])): ?>
                                <div class="col-md-3">
                                    <p><strong>Interest Rate:</strong><br>
                                    <span class="text-warning fw-bold"><?= $account['interestRate'] ?>%</span></p>
                                </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($account['installmentAmount'])): ?>
                                <div class="col-md-3">
                                    <p><strong>EMI Amount:</strong><br>
                                    <span>₹<?= number_format($account['installmentAmount']) ?></span><br>
                                    <small class="text-muted"><?= $account['termFrequency'] ?? 'Monthly' ?></small></p>
                                </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($account['repaymentTenure'])): ?>
                                <div class="col-md-3">
                                    <p><strong>Tenure:</strong><br>
                                    <span><?= $account['repaymentTenure'] ?> months</span></p>
                                </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($account['collateralValue'])): ?>
                                <div class="col-md-3">
                                    <p><strong>Collateral Value:</strong><br>
                                    <span class="text-info">₹<?= number_format($account['collateralValue']) ?></span></p>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <h6 class="mb-3">
                            <i class="fas fa-history me-2"></i>
                            Payment History (Last 48 Months)
                        </h6>
                        <div class="row g-1">
                            <?php if (!empty($account['history48Months'])): ?>
                                <?php foreach (array_reverse($account['history48Months']) as $history): ?>
                                <div class="col-auto">
                                    <div class="payment-history-cell <?= getPaymentStatusColor($history['paymentStatus']) ?>" 
                                         data-bs-toggle="tooltip" 
                                         title="<?= $history['key'] ?>: <?= $history['paymentStatus'] ?>">
                                        <div class="payment-status"><?= $history['paymentStatus'] ?></div>
                                        <div class="payment-month" style="font-size: 0.7rem;"><?= $history['key'] ?></div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="col-12">
                                    <p class="text-muted text-center">No Payment History Available</p>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Payment Status Legend -->
                        <div class="mt-3">
                            <small class="text-muted">
                                <strong>Payment Status Legend:</strong>
                                <span class="badge bg-success ms-2">000/STD - Current</span>
                                <span class="badge bg-warning ms-1">01+/30+ - 1-30 days overdue</span>
                                <span class="badge bg-danger ms-1">60+/90+/120+ - Seriously overdue</span>
                                <span class="badge bg-secondary ms-1">CLSD - Closed</span>
                            </small>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Inquiry Summary -->
        <div class="card">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0">
                    <i class="fas fa-search me-2"></i>
                    Credit Inquiry Summary
                </h5>
            </div>
            <div class="card-body">
                <?php $enquirySum = $report['enquirySummary']; ?>
                <div class="row text-center">
                    <div class="col-md-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-primary"><?= $enquirySum['total'] ?></h3>
                                <p class="mb-0">Total Inquiries</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-info"><?= $enquirySum['past30Days'] ?></h3>
                                <p class="mb-0">Last 30 Days</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-warning"><?= $enquirySum['past12Months'] ?></h3>
                                <p class="mb-0">Last 12 Months</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h3 class="text-secondary"><?= $enquirySum['past24Months'] ?></h3>
                                <p class="mb-0">Last 24 Months</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-12">
                        <p><strong>Most Recent Inquiry:</strong> <?= formatDate($enquirySum['recent']) ?></p>
                        <p><strong>Purpose:</strong> <?= $enquirySum['purpose'] ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Key Indicators -->
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Key Credit Indicators
                </h5>
            </div>
            <div class="card-body">
                <?php $keyInd = $report['otherKeyInd']; ?>
                <div class="row">
                    <div class="col-md-4">
                        <div class="card border-start border-4 border-info">
                            <div class="card-body">
                                <h4 class="text-info"><?= $keyInd['ageOfOldestTrade'] ?> months</h4>
                                <p class="mb-0">Age of Oldest Trade</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border-start border-4 border-success">
                            <div class="card-body">
                                <h4 class="text-success"><?= $keyInd['numberOfOpenTrades'] ?></h4>
                                <p class="mb-0">Number of Open Trades</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border-start border-4 border-danger">
                            <div class="card-body">
                                <h4 class="text-danger">₹<?= number_format($keyInd['allLinesEVERWritten']) ?></h4>
                                <p class="mb-0">All Lines Ever Written Off</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="card border-start border-4 border-warning">
                            <div class="card-body">
                                <h4 class="text-warning"><?= $keyInd['allLinesEVERWrittenIn6Months'] ?></h4>
                                <p class="mb-0">Write-offs in Last 6 Months</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border-start border-4 border-secondary">
                            <div class="card-body">
                                <h4 class="text-secondary"><?= $keyInd['allLinesEVERWrittenIn9Months'] ?></h4>
                                <p class="mb-0">Write-offs in Last 9 Months</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activities -->
        <div class="card">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-clock me-2"></i>
                        Recent Credit Activities
                    </h5>
                </div>
                <div class="card-body">
                    <?php $recentAct = $report['recentActivities']; ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-center">
                                <div class="display-6 text-<?= $recentAct['accountsDeliquent'] > 0 ? 'danger' : 'success' ?>">
                                    <?= $recentAct['accountsDeliquent'] ?>
                                </div>
                                <p class="text-muted">Delinquent Accounts</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <div class="display-6 text-primary"><?= $recentAct['accountsOpened'] ?></div>
                                <p class="text-muted">Accounts Opened</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <div class="display-6 text-info"><?= $recentAct['totalInquiries'] ?></div>
                                <p class="text-muted">Total Inquiries</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <div class="display-6 text-secondary"><?= $recentAct['accountsUpdated'] ?></div>
                                <p class="text-muted">Accounts Updated</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

    </div>
  

    <!-- Footer -->
    <footer class="bg-dark text-white text-center py-4 mt-5 print-hide">
        <div class="container">
            <p class="mb-0">&copy; 2024 CIBIL Score Report System. All rights reserved.</p>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jsPDF for PDF generation -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

    <script>
        function generatePDF() {
            const reportContent = document.getElementById('reportContent');
            
            html2canvas(reportContent, { 
                scale: 2,
                useCORS: true,
                allowTaint: true
            }).then(function(canvas) {
                const imgData = canvas.toDataURL('image/png');
                const { jsPDF } = window.jspdf;
                const pdf = new jsPDF('p', 'mm', 'a4');
                
                const imgWidth = 210;
                const pageHeight = 295;
                const imgHeight = (canvas.height * imgWidth) / canvas.width;
                let heightLeft = imgHeight;
                
                let position = 0;
                
                pdf.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
                heightLeft -= pageHeight;
                
                while (heightLeft >= 0) {
                    position = heightLeft - imgHeight;
                    pdf.addPage();
                    pdf.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
                    heightLeft -= pageHeight;
                }
                
                pdf.save('cibil_score_report.pdf');
            }).catch(function(error) {
                console.error('Error generating PDF:', error);
                alert('Error generating PDF. Please try again.');
            });
        }

        // Add smooth scrolling for better UX
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });

        // Add loading animation for PDF generation
        function showLoadingSpinner() {
            const spinner = document.createElement('div');
            spinner.className = 'position-fixed top-50 start-50 translate-middle';
            spinner.innerHTML = `
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            `;
            document.body.appendChild(spinner);
            return spinner;
        }

        function hideLoadingSpinner(spinner) {
            document.body.removeChild(spinner);
        }
    </script>
</body>
</html>