<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Common_model extends CI_Model {
	/**** INSERT, UPDATE and DELETE *****/
	
	public function Create($formArray,$table) {
		$this->db->insert($table,$formArray);
		return true;
	}
	

	public function Edit($column,$formArray,$table) {
		$this->db->where($column);
		$this->db->update($table,$formArray);
		
		return true;
	}

	public function Del($column,$table) {
		$this->db->where($column);
		$this->db->delete($table);
		
		return true;
	}
	
	/*************** All Get ********************/
	public function Results($table) {
		$results = $this->db->get($table)->result_array();
		return $results;
	}
	
		public function Resultss($table) {
		$results = $this->db->where('vender',0);
		$results = $this->db->get($table)->result_array();
		return $results;
	}
	
	public function Results_last_id($column_name,$table) {
		$this->db->order_by($column_name, 'desc');
		$results = $this->db->get($table)->row_array();
		return $results[$column_name];
	}
	
	public function ResultsWhere($column_name,$column_data,$table) {
		$this->db->where($column_name,$column_data);
		$results = $this->db->get($table)->result_array();
		return $results;
	}
	
	public function ResultsWhere2($column,$table) {
		$this->db->where($column);
		$results = $this->db->get($table)->result_array();
		return $results;
	}
	
	public function Results_or_Where3($column1,$column2,$table) {
		$this->db->where($column1);
		$this->db->or_where($column2);
		$results = $this->db->get($table)->result_array();
		return $results;
	}
	
	public function ResultsWhereASC($column_name,$column_name2,$column_data,$table) {
		$this->db->order_by($column_name2, 'asc');
		$this->db->where($column_name,$column_data);
		$results = $this->db->get($table)->result_array();
		return $results;
	}
	
	
	public function Result($column,$table) {
		$this->db->where($column);
		$result = $this->db->get($table)->row_array();
		return $result;
	}
	
	
	public function Count_Where($column,$table) {
		$this->db->where($column);
		$result = $this->db->get($table)->num_rows();
		return $result;
	}
	
	public function Count_Custom_Where($where,$table) {
		$this->db->where($where);
		$result = $this->db->get($table)->num_rows();
		return $result;
	}
	
	public function Count($table) {
		$result = $this->db->get($table)->num_rows();
		return $result;
	}
	
	public function Count_Group_By($column_name,$table) {
	    $this->db->group_by($column_name);
		$result = $this->db->get($table)->num_rows();
		return $result;
	}
	
	
	public function Select_Sum_By($column_name,$table) {
	    $this->db->select_sum($column_name);
        $result = $this->db->get($table)->row();  
        return $result->$column_name;
	}
	
	
	public function Select_Sum($column_name,$table) {
		$this->db->select_sum($column_name);
        $result = $this->db->get($table)->row();  
        return $result->$column_name;
	}
	
	public function Select_Sum_into_qty($column_name1,$column_name2,$table) {
		$this->db->select($column_name1);
		$this->db->select($column_name2);
        $result = $this->db->get($table)->result_array();  
        return $result;
	}
	
	public function Results_product($product,$top_cat,$mid_cat,$end_cat){
	        $this->db->select('*');
            $this->db->from($product.' t1'); 
            $this->db->join($end_cat.' t2', 't1.ecat_id = t2.ecat_id', 'ON');
            $this->db->join($mid_cat.' t3', 't2.mcat_id = t3.mcat_id', 'ON');
            $this->db->join($top_cat.' t4', 't3.tcat_id = t4.tcat_id', 'ON');
            $this->db->order_by('t1.p_id','DESC');         
            $query = $this->db->get(); 
            
            if($query->num_rows() != 0)
            {
                return $query->result_array();
            }
            else
            {
                return false;
            }
	}
	
	public function Results_product_id($product,$top_cat,$mid_cat,$end_cat,$id){
	        $this->db->select('*');
            $this->db->from($product.' t1'); 
            $this->db->join($end_cat.' t2', 't1.ecat_id = t2.ecat_id', 'ON');
            $this->db->join($mid_cat.' t3', 't2.mcat_id = t3.mcat_id', 'ON');
            $this->db->join($top_cat.' t4', 't3.tcat_id = t4.tcat_id', 'ON');
            $this->db->order_by('t1.p_id','DESC');         
            $this->db->where('t1.p_id',$id);         
            $query = $this->db->get(); 
            
            if($query->num_rows() != 0)
            {
                return $query->row_array();
            }
            else
            {
                return false;
            }
	}
	
	public function Results_product_size($size,$product_size){
	        $this->db->select('*');
            $this->db->from($product_size.' s1'); 
            $this->db->join($size.' s2', 's1.size_id = s2.size_id', 'ON');
            $this->db->order_by('s1.p_id','DESC');         
            $query = $this->db->get(); 
            
            if($query->num_rows() != 0)
            {
                return $query->result_array();
            }
            else
            {
                return false;
            }
	}
	
	public function Results_product_size_p_id($p_id,$size,$product_size){
	        $this->db->select('*');
            $this->db->from($product_size.' s1'); 
            $this->db->join($size.' s2', 's1.size_id = s2.size_id', 'ON');        
            $this->db->where('s1.p_id',$p_id);    
            $this->db->order_by('s1.p_id','DESC');      
            $query = $this->db->get(); 
            
            if($query->num_rows() != 0)
            {
                return $query->result_array();
            }
            else
            {
                return false;
            }
	}
	

}

/* End of file Common_model.php */
/* Location: ./application/models/Common_model.php */