<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {
	// Session Authoriesed
	public function __construct() {
		parent::__construct();
		
		$admin = $this->session->userdata('staff');
		$column['id'] = $admin['id'];
		$table = 'tbl_user';
		
	    // loading common model
	    $this->load->model('Common_model');
		$result = $this->Common_model->Result($column,$table);
		if($result['password'] == $admin['password']){
		    $login = true;
		} else {
		    $login = false;
		}
		
		if (empty($admin) || $login==false) {
			$this->session->set_flashdata('msg','Your Session Has Been Expired');
			redirect(base_url().'staff/login/index');
		}
	}

	public function index()
	{
        // loading form validation
        $this->load->library('form_validation');
        
        // loading common model
        $this->load->model('Common_model');
        
        $column['id'] = 1;
        $table = 'tbl_settings';
        // get common data
        $data['data'] = $this->Common_model->Result($column,$table);
        
       
          $table1 = 'tbl_customer';
        $column1['user'] =$_SESSION['staff']['id'];
        $data['customer'] = $cc=$this->Common_model->ResultsWhere2($column1,$table1);
		
	
        $page = 'customer';
        $data['page'] = $page;
        
        // here we are checking view is available
        if(file_exists('./application/views/staff/customer/list.php')){
            // loading page view
            $this->load->view('staff/customer/list',$data);
        }
        else
        {
            // loading 404 page
            redirect(base_url().'staff/page/index/404');
        }
	}
	
	
	public function cust_status($id)
	{
        // loading form validation
        $this->load->library('form_validation');
        
        // loading common model
        $this->load->model('Common_model');
        
        $table1 = 'tbl_customer';
        $column1['cust_id'] = $id;
        // get common data
        $customer = $this->Common_model->Result($column1,$table1);
        
        $status = $customer['cust_status'];
        
        if($status==0){
            $status = 1;
        } else{
            $status = 0;
        }
        
        $column['cust_id'] = $id;
        $table = 'tbl_customer';
        $data['cust_status'] = $status;
        
        // we are updating data from tbl_p_type
        $result  = $this->Common_model->Edit($column,$data,$table);
        
        if($result == true){
            $this->session->set_flashdata('success','SUCCESS!! User Status Changed Successfully.');
		    redirect(base_url('staff/customer'));
		    exit();
        } else{
            $this->session->set_flashdata('error','Something went Wrong .');
		    redirect(base_url('staff/customer'));
		    exit();
        }
	}

	public function send_message($id)
	{
        // loading form validation
        $this->load->library('form_validation');
        
        // loading common model
        $this->load->model('Common_model');
        
        $column['id'] = 1;
        $table = 'tbl_settings';
        // get common data
        $data['data'] = $this->Common_model->Result($column,$table);
        
        $table1 = 'tbl_customer';
        $column1['cust_id'] = $id;
        // get common data
        $data['customer'] = $this->Common_model->Result($column1,$table1);
        
        // get page name
        $page = 'Send Message';
        $data['page'] = $page;
        
        // here we are checking view is available
        if(file_exists('./application/views/master/customer/send_message.php')){
            // loading page view
            $this->load->view('staff/customer/send_message',$data);
        }
        else
        {
            // loading 404 page
            redirect(base_url().'staff/page/index/404');
        }
	}


	public function view($id)
	{
        // loading form validation
        $this->load->library('form_validation');
        
        // loading common model
        $this->load->model('Common_model');
        
        $column['id'] = 1;
        $table = 'tbl_settings';
        // get common data
        $data['data'] = $this->Common_model->Result($column,$table);
        
        $table1 = 'tbl_customer';
        $column1['cust_id'] = $id;
        // get common data
        $data['customer'] = $this->Common_model->Result($column1,$table1);
        
        // get page name
        $page = 'Customer View';
        $data['page'] = $page;
        
        // here we are checking view is available
        if(file_exists('./application/views/staff/customer/view.php')){
            // loading page view
            $this->load->view('staff/customer/view',$data);
        }
        else
        {
            // loading 404 page
            redirect(base_url().'staff/page/index/404');
        }
	}
	
	
	public function send($id)
	{
        // loading form validation
        $this->load->library('form_validation');
        
        // loading common model
        $this->load->model('Common_model');
        
        $data = [];
        if (empty($_POST['message_text'])) {
            $this->session->set_flashdata('error',''.strtoupper("Message Text").' Can not be Empty.');
		    redirect(base_url('staff/customer/send_message/'.$id));
		    exit();
        }
        
        $table1 = 'tbl_customer';
        $column1['cust_id'] = $id;
        // get common data
        $customer = $this->Common_model->Result($column1,$table1);
        
        $table = 'tbl_settings';
        $column['id'] = 1;
        // get common data
        $settings = $this->Common_model->Result($column,$table);
        
        
        $header = '';
        $message_text = htmlspecialchars($_POST['message_text']);
        
        // sending message on mail
        $to = $customer['cust_email'];
        $subject = "Information From ".$settings['base_name'];
        $message = $message_text;
        $header .= "MIME-Version: 1.0\r\n";
        $header .= "Content-type: text/html\r\n";
        $header = "From:".$settings['contact_email']."\r\n";
        $header .= "Cc:".$settings['base_name']."\r\n";
        $header .= "MIME-Version: 1.0\r\n";
        $header .= "Content-type: text/html\r\n";
        $retval = mail ($to,$subject,$message,$header);
        
        // sending message on mobile
        $sender = $settings['sms_sender'];
        $username = $settings['sms_user'];
        $password2 = $settings['sms_pass']; 
        $number = $customer['cust_phone'];
        $message = $message_text;
        $url = "http://buzz.azmarq.com/http-api.php?username=".urlencode($username)."&password=".urlencode($password2)."&senderid=".urlencode($sender)."&route=1&number=".urlencode($number)."&message=".urlencode($message);
        file_get_contents($url);
        
        
            $this->session->set_flashdata('success','SUCCESS!! Message Sent Successfully.');
		    redirect(base_url('staff/customer/send_message/'.$id));
		    exit();
	}


}

?>