<?php  include('header.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Gallery</title>
  <style>
    .gallery-item img {
      width: 100%;
      height: auto;
      border-radius: 8px;
      cursor: pointer;
    }

    .list-view .gallery-item {
      display: flex;
      gap: 15px;
      margin-bottom: 15px;
    }

    .list-view .gallery-item img {
      width: 200px;
      height: 150px;
      object-fit: cover;
    }

    .list-view .gallery-item .info {
      flex: 1;
      display: flex;
      align-items: center;
    }

    .view-toggle {
      margin-bottom: 20px;
    }

    .modal-img {
      width: 100%;
    }
  </style>
</head>
<body>
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center view-toggle">
    <h2>Legal Documents</h2>
   
  </div>

  <div id="gallery" class="row g-3 grid-view">
    <!-- Gallery Items -->
    
   
    <div class="col-md-4 gallery-item">
      <img src="<?= base_url('uploads/legal/l1.jpg'); ?>" alt="Gallery Image" onclick="openModal(this)">
     
    </div>
    
   
    
     <div class="col-md-4 gallery-item">
      <img src="<?= base_url('uploads/legal/l3.jpg'); ?>" alt="Gallery Image" onclick="openModal(this)">
     
    </div>
    
     <div class="col-md-4 gallery-item">
      <img src="<?= base_url('uploads/legal/l4.JPG'); ?>" alt="Gallery Image" onclick="openModal(this)">
     
    </div>
      <div class="col-md-4 gallery-item">
      <img src="<?= base_url('uploads/legal/l2.jpg'); ?>" alt="Gallery Image" onclick="openModal(this)">
     
    </div>

  </div>
</div>




<script>
  function toggleView(viewType) {
    const gallery = document.getElementById("gallery");
    const items = gallery.querySelectorAll(".gallery-item");

    if (viewType === "list") {
      gallery.classList.remove("row", "grid-view");
      gallery.classList.add("list-view");
      items.forEach(item => {
        item.classList.remove("col-md-4");
        item.querySelector(".info").classList.remove("d-none");
      });
    } else {
      gallery.classList.remove("list-view");
      gallery.classList.add("row", "grid-view");
      items.forEach(item => {
        item.classList.add("col-md-4");
        item.querySelector(".info").classList.add("d-none");
      });
    }
  }

  function openModal(img) {
    const modalImage = document.getElementById('modalImage');
    modalImage.src = img.src;
    const modal = new bootstrap.Modal(document.getElementById('imageModal'));
    modal.show();
  }
</script>

</body>
</html>

<?php include('footer.php');?>

<!-- Fullscreen Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog" style="width: 100%; max-width: 100%; margin: 0;">
    <div class="modal-content" style="background-color: black; width: 100%;">
      <div class="modal-header border-0">
        <button type="button" class="btn-close btn-close-white ms-auto" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body d-flex justify-content-center align-items-center" style="padding: 0;">
        <img id="modalImage" src="" alt="Full View"
             style="width: 100%; height: auto; max-height: 100vh; object-fit: contain;" />
      </div>
    </div>
  </div>
</div>
