<!DOCTYPE html>
<html lang="en">
<head>
        <meta charset="utf-8" />
        <title>Login || Staff Dashboard</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="Staff Dashboard" name="description" />
        <meta content="Decent Web Services LLP" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo base_url();?>/assets/images/favicon.ico">

        <!-- App css -->
        <link href="<?php echo base_url();?>/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap-stylesheet" />
        <link href="<?php echo base_url();?>/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url();?>/assets/css/app.min.css" rel="stylesheet" type="text/css"  id="app-stylesheet" />
    
    </head>

    <body class="authentication-bg bg-white">

        <div class="account-pages pt-5 my-5">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-5">
                        <div class="account-card-box">
                            <div class="card mb-0">
                                <div class="card-body p-4">
                                    
                                    <div class="text-center">
                                        <h4 class="pb-2 text-body text-uppercase">Staff Panel</h4>
                                    </div>
                                    
                                <form action="<?= base_url().'staff/login/authenticate'; ?>" name="loginForm" id="loginForm" method="post">
                                    <div class="input-group mb-3">
                                      <input type="text" class="form-control" name="username" id="username" placeholder="Username">
                                      <div class="input-group-append">
                                        <div class="input-group-text">
                                          <span class="fas fa-envelope"></span>
                                        </div>
                                      </div>
                                    </div>
                                    <?php echo form_error('username');?>
                                    <div class="input-group mb-3">
                                      <input type="password" class="form-control" name="password" id="password" placeholder="Password">
                                      <div class="input-group-append">
                                        <div class="input-group-text">
                                          <span class="fas fa-lock"></span>
                                        </div>
                                      </div>
                                    </div>
                                    <?php echo form_error('password');?>
                                    <div class="row">
                                      <div class="col-6">
                                        <div class="icheck-primary">
                                          <input type="checkbox" id="remember">
                                          <label for="remember">
                                            Remember Me
                                          </label>
                                        </div>
                                      </div>
                                      <!-- /.col -->
                                      <div class="col-6">
                                        <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                                      </div>
                                      <!-- /.col -->
                                    </div>
                                  </form>
                                  
                                </div> <!-- end card-body -->
                                <div class="px-3 py-0 my-0">
                                    <?php 
                                    $message = $this->session->flashdata('msg');
                                    if (isset($message)) {
                                      echo "<div class='alert alert-danger'>".$message."</div>";
                                    }
                                    
                                    $success = $this->session->flashdata('success');
                                    if (isset($success)) {
                                      echo "<div class='alert alert-success'>".$success."</div>";
                                    }
                                  ?>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>

                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end page -->

        <!-- Vendor js -->
        <script src="<?php echo base_url();?>/assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="<?php echo base_url();?>/assets/js/app.min.js"></script>
        
        <script>
            setTimeout(function(){ $(".alert").hide(); }, 5000);
        </script>
        
    </body>
</html>