<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {
	// Session Authoriesed
	public function __construct() {
		parent::__construct();
		
		$admin = $this->session->userdata('staff');
		$column['id'] = $admin['id'];
		$table = 'tbl_user';
		
	    // loading common model
	    $this->load->model('Common_model');
		$result = $this->Common_model->Result($column,$table);
		if($result['password'] == $admin['password']){
		    $login = true;
		} else {
		    $login = false;
		}
		
		if (empty($admin) || $login==false) {
			$this->session->set_flashdata('msg','Your Session Has Been Expired');
			redirect(base_url().'staff/login/index');
		}
	}

	public function index()
	{
		
        // we are setting data for get site data
		$column['id'] = '1';
		$table = 'tbl_settings';
		
        // we are getting results from common modal
		$result = $this->Common_model->Result($column,$table);
		
        // we are setting result in data array as $data
		$data['data'] = $result;
		$data['page'] = 'dashboard';
		
		$data['faq'] = $this->Common_model->Count('tbl_faq');
		$data['customer'] = $this->Common_model->Count('tbl_customer');
		$data['product'] = $this->Common_model->Count('tbl_product');
		
		$data['stock_amt'] = $this->Common_model->Select_Sum('total','staff_stock_list');
		
// 		$data['sold_amt'] = $this->Common_model->Select_Sum('unit_price','tbl_order');

		$result2 = $this->Common_model->Select_Sum_into_qty('unit_price','quantity','tbl_order');
		$sold_amt = 0;
		foreach($result2 as $row){
		    $sold_amt += $row['unit_price']*$row['quantity'];
		}
		$data['sold_amt'] = $sold_amt;
		
		$data['product_sold'] = $this->Common_model->Select_Sum_By('quantity','tbl_order');
		$data['order'] = $this->Common_model->Count('tbl_payment');
		$data['top_category'] = $this->Common_model->Count('tbl_top_category');
		$data['mid_category'] = $this->Common_model->Count('tbl_mid_category');
		$data['end_category'] = $this->Common_model->Count('tbl_end_category');
		$data['state'] = $this->Common_model->Count('tbl_state');
		$data['district'] = $this->Common_model->Count('tbl_district');
		
        // we are loading admin dashboard
		$this->load->view('staff/dashboard',$data);	
	}
	
}

/* End of file Dashboard.php */
/* Location: ./application/controllers/staff/Dashboard.php */